/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.client.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClass;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClassBuilder;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClassList;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotList;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotClassResource;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotOperationsImpl;
import java.util.HashMap;
import okhttp3.OkHttpClient;

public class VolumeSnapshotClassOperationsImpl
extends HasMetadataOperation<VolumeSnapshotClass, VolumeSnapshotClassList, VolumeSnapshotClassResource>
implements VolumeSnapshotClassResource {
    public VolumeSnapshotClassOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public VolumeSnapshotClassOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("snapshot.storage.k8s.io").withApiGroupVersion("v1").withPlural("volumesnapshotclasses"));
        this.type = VolumeSnapshotClass.class;
        this.listType = VolumeSnapshotClassList.class;
    }

    public BaseOperation<VolumeSnapshotClass, VolumeSnapshotClassList, VolumeSnapshotClassResource> newInstance(OperationContext context) {
        return new VolumeSnapshotClassOperationsImpl(context);
    }

    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public VolumeSnapshotList listSnapshots() {
        VolumeSnapshotClass item = (VolumeSnapshotClass)this.get();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("spec.volumeSnapshotClassName", item.getMetadata().getName());
        return (VolumeSnapshotList)new VolumeSnapshotOperationsImpl(this.context.withName(null)).withFields(fields).list();
    }

    public VolumeSnapshotClass edit(Visitor ... visitors) {
        return (VolumeSnapshotClass)this.patch(((VolumeSnapshotClassBuilder)new VolumeSnapshotClassBuilder((VolumeSnapshotClass)this.getMandatory()).accept(visitors)).build());
    }
}

