

                        

package io.fabric8.volumesnapshot.client.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.volumesnapshot.api.model.VolumeSnapshot;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotBuilder;

public class VolumeSnapshotHandler implements ResourceHandler<VolumeSnapshot, VolumeSnapshotBuilder> {

  @Override
  public String getKind() {
    return VolumeSnapshot.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "snapshot.storage.k8s.io/v1";
      }

  @Override
  public VolumeSnapshotBuilder edit(VolumeSnapshot item) {
    return new VolumeSnapshotBuilder(item);
  }

  @Override
  public Resource<VolumeSnapshot> resource(OkHttpClient client, Config config, String namespace, VolumeSnapshot item) {
    return new VolumeSnapshotOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
