

                        

package io.fabric8.volumesnapshot.client.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotContentOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentBuilder;

public class VolumeSnapshotContentHandler implements ResourceHandler<VolumeSnapshotContent, VolumeSnapshotContentBuilder> {

  @Override
  public String getKind() {
    return VolumeSnapshotContent.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "snapshot.storage.k8s.io/v1";
      }

  @Override
  public VolumeSnapshotContentBuilder edit(VolumeSnapshotContent item) {
    return new VolumeSnapshotContentBuilder(item);
  }

  @Override
  public Resource<VolumeSnapshotContent> resource(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item) {
    return new VolumeSnapshotContentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
