

                        

package io.fabric8.volumesnapshot.client.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotClassOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClass;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClassBuilder;

public class VolumeSnapshotClassHandler implements ResourceHandler<VolumeSnapshotClass, VolumeSnapshotClassBuilder> {

  @Override
  public String getKind() {
    return VolumeSnapshotClass.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "snapshot.storage.k8s.io/v1";
      }

  @Override
  public VolumeSnapshotClassBuilder edit(VolumeSnapshotClass item) {
    return new VolumeSnapshotClassBuilder(item);
  }

  @Override
  public Resource<VolumeSnapshotClass> resource(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item) {
    return new VolumeSnapshotClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
