

                        

package io.fabric8.volumesnapshot.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshot;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class VolumeSnapshotHandler implements ResourceHandler<VolumeSnapshot, VolumeSnapshotBuilder> {

  @Override
  public String getKind() {
    return VolumeSnapshot.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "snapshot.storage.k8s.io/v1";
      }

  @Override
  public VolumeSnapshot create(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, boolean dryRun) {
    return new VolumeSnapshotOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public VolumeSnapshot replace(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, boolean dryRun) {
    return new VolumeSnapshotOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public VolumeSnapshot reload(OkHttpClient client, Config config, String namespace, VolumeSnapshot item) {
    return new VolumeSnapshotOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public VolumeSnapshotBuilder edit(VolumeSnapshot item) {
    return new VolumeSnapshotBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, VolumeSnapshot item, boolean dryRun) {
    return new VolumeSnapshotOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, Watcher<VolumeSnapshot> watcher) {
    return new VolumeSnapshotOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, String resourceVersion, Watcher<VolumeSnapshot> watcher) {
    return new VolumeSnapshotOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, ListOptions listOptions, Watcher<VolumeSnapshot> watcher) {
    return new VolumeSnapshotOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public VolumeSnapshot waitUntilReady(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new VolumeSnapshotOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public VolumeSnapshot waitUntilCondition(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, Predicate<VolumeSnapshot> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new VolumeSnapshotOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
