

                        

package io.fabric8.volumesnapshot.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotClassOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClass;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClassBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class VolumeSnapshotClassHandler implements ResourceHandler<VolumeSnapshotClass, VolumeSnapshotClassBuilder> {

  @Override
  public String getKind() {
    return VolumeSnapshotClass.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "snapshot.storage.k8s.io/v1";
      }

  @Override
  public VolumeSnapshotClass create(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item) {
    return new VolumeSnapshotClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public VolumeSnapshotClass replace(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item) {
    return new VolumeSnapshotClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public VolumeSnapshotClass reload(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item) {
    return new VolumeSnapshotClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public VolumeSnapshotClassBuilder edit(VolumeSnapshotClass item) {
    return new VolumeSnapshotClassBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, VolumeSnapshotClass item) {
    return new VolumeSnapshotClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item, Watcher<VolumeSnapshotClass> watcher) {
    return new VolumeSnapshotClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item, String resourceVersion, Watcher<VolumeSnapshotClass> watcher) {
    return new VolumeSnapshotClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item, ListOptions listOptions, Watcher<VolumeSnapshotClass> watcher) {
    return new VolumeSnapshotClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

@Override
  public VolumeSnapshotClass waitUntilReady(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new VolumeSnapshotClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public VolumeSnapshotClass waitUntilCondition(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item, Predicate<VolumeSnapshotClass> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new VolumeSnapshotClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
