

                        

package io.fabric8.volumesnapshot.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotContentOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class VolumeSnapshotContentHandler implements ResourceHandler<VolumeSnapshotContent, VolumeSnapshotContentBuilder> {

  @Override
  public String getKind() {
    return VolumeSnapshotContent.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "snapshot.storage.k8s.io/v1beta1";
      }

  @Override
  public VolumeSnapshotContent create(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item) {
    return new VolumeSnapshotContentOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public VolumeSnapshotContent replace(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item) {
    return new VolumeSnapshotContentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public VolumeSnapshotContent reload(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item) {
    return new VolumeSnapshotContentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public VolumeSnapshotContentBuilder edit(VolumeSnapshotContent item) {
    return new VolumeSnapshotContentBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, VolumeSnapshotContent item) {
    return new VolumeSnapshotContentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item, Watcher<VolumeSnapshotContent> watcher) {
    return new VolumeSnapshotContentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item, String resourceVersion, Watcher<VolumeSnapshotContent> watcher) {
    return new VolumeSnapshotContentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item, ListOptions listOptions, Watcher<VolumeSnapshotContent> watcher) {
    return new VolumeSnapshotContentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

@Override
  public VolumeSnapshotContent waitUntilReady(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new VolumeSnapshotContentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public VolumeSnapshotContent waitUntilCondition(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item, Predicate<VolumeSnapshotContent> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new VolumeSnapshotContentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
