/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshot;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotBuilder;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotOperationsImpl;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotResource;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class VolumeSnapshotHandler
implements ResourceHandler<VolumeSnapshot, VolumeSnapshotBuilder> {
    public String getKind() {
        return VolumeSnapshot.class.getSimpleName();
    }

    public String getApiVersion() {
        return "snapshot.storage.k8s.io/v1beta1";
    }

    public VolumeSnapshot create(OkHttpClient client, Config config, String namespace, VolumeSnapshot item) {
        return (VolumeSnapshot)new VolumeSnapshotOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new VolumeSnapshot[0]);
    }

    public VolumeSnapshot replace(OkHttpClient client, Config config, String namespace, VolumeSnapshot item) {
        return (VolumeSnapshot)((VolumeSnapshotResource)new VolumeSnapshotOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    public VolumeSnapshot reload(OkHttpClient client, Config config, String namespace, VolumeSnapshot item) {
        return (VolumeSnapshot)((Gettable)((VolumeSnapshotResource)new VolumeSnapshotOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public VolumeSnapshotBuilder edit(VolumeSnapshot item) {
        return new VolumeSnapshotBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, VolumeSnapshot item) {
        return ((EditReplacePatchDeletable)((VolumeSnapshotResource)new VolumeSnapshotOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).withPropagationPolicy(propagationPolicy)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, Watcher<VolumeSnapshot> watcher) {
        return ((VolumeSnapshotResource)new VolumeSnapshotOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, String resourceVersion, Watcher<VolumeSnapshot> watcher) {
        return ((VolumeSnapshotResource)new VolumeSnapshotOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, ListOptions listOptions, Watcher<VolumeSnapshot> watcher) {
        return ((VolumeSnapshotResource)new VolumeSnapshotOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(listOptions, watcher);
    }

    public VolumeSnapshot waitUntilReady(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (VolumeSnapshot)((VolumeSnapshotResource)new VolumeSnapshotOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public VolumeSnapshot waitUntilCondition(OkHttpClient client, Config config, String namespace, VolumeSnapshot item, Predicate<VolumeSnapshot> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (VolumeSnapshot)((VolumeSnapshotResource)new VolumeSnapshotOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

