/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClass;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotClassBuilder;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotClassOperationsImpl;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotClassResource;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class VolumeSnapshotClassHandler
implements ResourceHandler<VolumeSnapshotClass, VolumeSnapshotClassBuilder> {
    public String getKind() {
        return VolumeSnapshotClass.class.getSimpleName();
    }

    public String getApiVersion() {
        return "snapshot.storage.k8s.io/v1beta1";
    }

    public VolumeSnapshotClass create(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item) {
        return (VolumeSnapshotClass)new VolumeSnapshotClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new VolumeSnapshotClass[0]);
    }

    public VolumeSnapshotClass replace(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item) {
        return (VolumeSnapshotClass)((VolumeSnapshotClassResource)new VolumeSnapshotClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    public VolumeSnapshotClass reload(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item) {
        return (VolumeSnapshotClass)((Gettable)((VolumeSnapshotClassResource)new VolumeSnapshotClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public VolumeSnapshotClassBuilder edit(VolumeSnapshotClass item) {
        return new VolumeSnapshotClassBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, VolumeSnapshotClass item) {
        return ((EditReplacePatchDeletable)((VolumeSnapshotClassResource)new VolumeSnapshotClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).withPropagationPolicy(propagationPolicy)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item, Watcher<VolumeSnapshotClass> watcher) {
        return ((VolumeSnapshotClassResource)new VolumeSnapshotClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item, String resourceVersion, Watcher<VolumeSnapshotClass> watcher) {
        return ((VolumeSnapshotClassResource)new VolumeSnapshotClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item, ListOptions listOptions, Watcher<VolumeSnapshotClass> watcher) {
        return ((VolumeSnapshotClassResource)new VolumeSnapshotClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(listOptions, watcher);
    }

    public VolumeSnapshotClass waitUntilReady(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (VolumeSnapshotClass)((VolumeSnapshotClassResource)new VolumeSnapshotClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public VolumeSnapshotClass waitUntilCondition(OkHttpClient client, Config config, String namespace, VolumeSnapshotClass item, Predicate<VolumeSnapshotClass> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (VolumeSnapshotClass)((VolumeSnapshotClassResource)new VolumeSnapshotClassOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

