/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentBuilder;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotContentOperationsImpl;
import io.fabric8.volumesnapshot.client.internal.VolumeSnapshotContentResource;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class VolumeSnapshotContentHandler
implements ResourceHandler<VolumeSnapshotContent, VolumeSnapshotContentBuilder> {
    public String getKind() {
        return VolumeSnapshotContent.class.getSimpleName();
    }

    public String getApiVersion() {
        return "snapshot.storage.k8s.io/v1beta1";
    }

    public VolumeSnapshotContent create(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item) {
        return (VolumeSnapshotContent)new VolumeSnapshotContentOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).create((Object[])new VolumeSnapshotContent[0]);
    }

    public VolumeSnapshotContent replace(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item) {
        return (VolumeSnapshotContent)((VolumeSnapshotContentResource)new VolumeSnapshotContentOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    public VolumeSnapshotContent reload(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item) {
        return (VolumeSnapshotContent)((Gettable)((VolumeSnapshotContentResource)new VolumeSnapshotContentOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public VolumeSnapshotContentBuilder edit(VolumeSnapshotContent item) {
        return new VolumeSnapshotContentBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, VolumeSnapshotContent item) {
        return (Boolean)((EditReplacePatchDeletable)((VolumeSnapshotContentResource)new VolumeSnapshotContentOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).withPropagationPolicy(propagationPolicy)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item, Watcher<VolumeSnapshotContent> watcher) {
        return (Watch)((VolumeSnapshotContentResource)new VolumeSnapshotContentOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item, String resourceVersion, Watcher<VolumeSnapshotContent> watcher) {
        return (Watch)((VolumeSnapshotContentResource)new VolumeSnapshotContentOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item, ListOptions listOptions, Watcher<VolumeSnapshotContent> watcher) {
        return (Watch)((VolumeSnapshotContentResource)new VolumeSnapshotContentOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(listOptions, watcher);
    }

    public VolumeSnapshotContent waitUntilReady(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (VolumeSnapshotContent)((VolumeSnapshotContentResource)new VolumeSnapshotContentOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public VolumeSnapshotContent waitUntilCondition(OkHttpClient client, Config config, String namespace, VolumeSnapshotContent item, Predicate<VolumeSnapshotContent> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (VolumeSnapshotContent)((VolumeSnapshotContentResource)new VolumeSnapshotContentOperationsImpl(client, config).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

