/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.server.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.volcano.client.NamespacedVolcanoClient;
import io.fabric8.volcano.client.VolcanoClient;
import io.fabric8.volcano.server.mock.EnableVolcanoMockClient;
import io.fabric8.volcano.server.mock.VolcanoMockServer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class VolcanoMockServerExtension
extends KubernetesMockServerExtension {
    private VolcanoMockServer volcanoMockServer;
    private NamespacedVolcanoClient volcanoClient;
    final Map<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();

    protected void destroy() {
        this.volcanoMockServer.destroy();
        this.volcanoClient.close();
    }

    protected Class<?> getClientType() {
        return VolcanoClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return VolcanoMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableVolcanoMockClient a = testClass.getAnnotation(EnableVolcanoMockClient.class);
        this.volcanoMockServer = a.crud() ? new VolcanoMockServer(new Context(), new MockWebServer(), this.responses, (Dispatcher)new KubernetesMixedDispatcher(this.responses), a.https()) : new VolcanoMockServer(a.https());
        this.volcanoMockServer.init();
        this.volcanoClient = this.volcanoMockServer.createVolcano();
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.volcanoClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.volcanoMockServer));
    }
}

