/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.server.mock;

import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.volcano.client.VolcanoClient;
import io.fabric8.volcano.server.mock.VolcanoMockServer;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.rules.ExternalResource;

public class VolcanoServer
extends ExternalResource {
    protected VolcanoMockServer mock;
    private VolcanoClient client;
    private final boolean https;
    private final boolean crudMode;

    public VolcanoServer() {
        this(true, false);
    }

    public VolcanoServer(boolean https) {
        this(https, false);
    }

    public VolcanoServer(boolean https, boolean crudMode) {
        this.https = https;
        this.crudMode = crudMode;
    }

    public void before() {
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.mock = this.crudMode ? new VolcanoMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), true) : new VolcanoMockServer(this.https);
        this.mock.init();
        this.client = this.mock.createVolcano();
    }

    public void after() {
        this.mock.destroy();
        this.client.close();
    }

    public VolcanoClient getVolcanoClient() {
        return this.client;
    }

    public MockServerExpectation expect() {
        return this.mock.expect();
    }

    @Deprecated
    public <T> void expectAndReturnAsJson(String path, int code, T body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, body)).always();
    }

    @Deprecated
    public void expectAndReturnAsString(String path, int code, String body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, (Object)body)).always();
    }
}

