package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodGroupSpecBuilder extends PodGroupSpecFluent<PodGroupSpecBuilder> implements VisitableBuilder<PodGroupSpec,PodGroupSpecBuilder>{
  public PodGroupSpecBuilder() {
    this(new PodGroupSpec());
  }
  
  public PodGroupSpecBuilder(PodGroupSpecFluent<?> fluent) {
    this(fluent, new PodGroupSpec());
  }
  
  public PodGroupSpecBuilder(PodGroupSpecFluent<?> fluent,PodGroupSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodGroupSpecBuilder(PodGroupSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodGroupSpecFluent<?> fluent;
  
  public PodGroupSpec build() {
    PodGroupSpec buildable = new PodGroupSpec(fluent.getMinMember(),fluent.getMinResources(),fluent.getPriorityClassName(),fluent.getQueue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}