/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.volcano.scheduling.v1beta1.PodGroupCondition;
import io.fabric8.volcano.scheduling.v1beta1.PodGroupConditionBuilder;
import io.fabric8.volcano.scheduling.v1beta1.PodGroupConditionFluent;
import io.fabric8.volcano.scheduling.v1beta1.PodGroupStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PodGroupStatusFluent<A extends PodGroupStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<PodGroupConditionBuilder> conditions = new ArrayList();
    private Integer failed;
    private String phase;
    private Integer running;
    private Integer succeeded;

    public PodGroupStatusFluent() {
    }

    public PodGroupStatusFluent(PodGroupStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodGroupStatus instance) {
        PodGroupStatus podGroupStatus = instance = instance != null ? instance : new PodGroupStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withFailed(instance.getFailed());
            this.withPhase(instance.getPhase());
            this.withRunning(instance.getRunning());
            this.withSucceeded(instance.getSucceeded());
            this.withConditions(instance.getConditions());
            this.withFailed(instance.getFailed());
            this.withPhase(instance.getPhase());
            this.withRunning(instance.getRunning());
            this.withSucceeded(instance.getSucceeded());
        }
    }

    public A addToConditions(int index, PodGroupCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, PodGroupCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(PodGroupCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (PodGroupCondition item : items) {
            PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<PodGroupCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (PodGroupCondition item : items) {
            PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(PodGroupCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (PodGroupCondition item : items) {
            PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<PodGroupCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (PodGroupCondition item : items) {
            PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<PodGroupConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<PodGroupConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            PodGroupConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PodGroupCondition> buildConditions() {
        return this.conditions != null ? PodGroupStatusFluent.build(this.conditions) : null;
    }

    public PodGroupCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public PodGroupCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public PodGroupCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public PodGroupCondition buildMatchingCondition(Predicate<PodGroupConditionBuilder> predicate) {
        for (PodGroupConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<PodGroupConditionBuilder> predicate) {
        for (PodGroupConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<PodGroupCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (PodGroupCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(PodGroupCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (PodGroupCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(PodGroupCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, PodGroupCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<PodGroupConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Integer getFailed() {
        return this.failed;
    }

    public A withFailed(Integer failed) {
        this.failed = failed;
        return (A)((Object)this);
    }

    public boolean hasFailed() {
        return this.failed != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public Integer getRunning() {
        return this.running;
    }

    public A withRunning(Integer running) {
        this.running = running;
        return (A)((Object)this);
    }

    public boolean hasRunning() {
        return this.running != null;
    }

    public Integer getSucceeded() {
        return this.succeeded;
    }

    public A withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (A)((Object)this);
    }

    public boolean hasSucceeded() {
        return this.succeeded != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodGroupStatusFluent that = (PodGroupStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.failed, that.failed)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.running, that.running)) {
            return false;
        }
        return Objects.equals(this.succeeded, that.succeeded);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.failed, this.phase, this.running, this.succeeded, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.failed != null) {
            sb.append("failed:");
            sb.append(this.failed + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.running != null) {
            sb.append("running:");
            sb.append(this.running + ",");
        }
        if (this.succeeded != null) {
            sb.append("succeeded:");
            sb.append(this.succeeded);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends PodGroupConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        PodGroupConditionBuilder builder;
        int index;

        ConditionsNested(int index, PodGroupCondition item) {
            this.index = index;
            this.builder = new PodGroupConditionBuilder(this, item);
        }

        public N and() {
            return (N)PodGroupStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

