package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QueueSpecBuilder extends QueueSpecFluent<QueueSpecBuilder> implements VisitableBuilder<QueueSpec,QueueSpecBuilder>{
  public QueueSpecBuilder() {
    this(new QueueSpec());
  }
  
  public QueueSpecBuilder(QueueSpecFluent<?> fluent) {
    this(fluent, new QueueSpec());
  }
  
  public QueueSpecBuilder(QueueSpecFluent<?> fluent,QueueSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QueueSpecBuilder(QueueSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QueueSpecFluent<?> fluent;
  
  public QueueSpec build() {
    QueueSpec buildable = new QueueSpec(fluent.getCapability(),fluent.getReclaimable(),fluent.getWeight());
    return buildable;
  }
  

}