package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QueueBuilder extends QueueFluent<QueueBuilder> implements VisitableBuilder<Queue,QueueBuilder>{
  public QueueBuilder() {
    this(new Queue());
  }
  
  public QueueBuilder(QueueFluent<?> fluent) {
    this(fluent, new Queue());
  }
  
  public QueueBuilder(QueueFluent<?> fluent,Queue instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QueueBuilder(Queue instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QueueFluent<?> fluent;
  
  public Queue build() {
    Queue buildable = new Queue(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}