package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PodGroupStatusFluent<A extends PodGroupStatusFluent<A>> extends BaseFluent<A>{
  public PodGroupStatusFluent() {
  }
  
  public PodGroupStatusFluent(PodGroupStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<PodGroupConditionBuilder> conditions = new ArrayList<PodGroupConditionBuilder>();
  private Integer failed;
  private String phase;
  private Integer running;
  private Integer succeeded;
  
  protected void copyInstance(PodGroupStatus instance) {
    instance = (instance != null ? instance : new PodGroupStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withFailed(instance.getFailed());
          this.withPhase(instance.getPhase());
          this.withRunning(instance.getRunning());
          this.withSucceeded(instance.getSucceeded());
          this.withConditions(instance.getConditions());
          this.withFailed(instance.getFailed());
          this.withPhase(instance.getPhase());
          this.withRunning(instance.getRunning());
          this.withSucceeded(instance.getSucceeded());
        }
  }
  
  public A addToConditions(int index,PodGroupCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<PodGroupConditionBuilder>();}
    PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,PodGroupCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<PodGroupConditionBuilder>();}
    PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.volcano.scheduling.v1beta1.PodGroupCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<PodGroupConditionBuilder>();}
    for (PodGroupCondition item : items) {PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<PodGroupCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<PodGroupConditionBuilder>();}
    for (PodGroupCondition item : items) {PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.volcano.scheduling.v1beta1.PodGroupCondition... items) {
    if (this.conditions == null) return (A)this;
    for (PodGroupCondition item : items) {PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<PodGroupCondition> items) {
    if (this.conditions == null) return (A)this;
    for (PodGroupCondition item : items) {PodGroupConditionBuilder builder = new PodGroupConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<PodGroupConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<PodGroupConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      PodGroupConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PodGroupCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public PodGroupCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public PodGroupCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public PodGroupCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public PodGroupCondition buildMatchingCondition(Predicate<PodGroupConditionBuilder> predicate) {
      for (PodGroupConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<PodGroupConditionBuilder> predicate) {
      for (PodGroupConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<PodGroupCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (PodGroupCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.volcano.scheduling.v1beta1.PodGroupCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (PodGroupCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(PodGroupCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,PodGroupCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<PodGroupConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public Integer getFailed() {
    return this.failed;
  }
  
  public A withFailed(Integer failed) {
    this.failed = failed;
    return (A) this;
  }
  
  public boolean hasFailed() {
    return this.failed != null;
  }
  
  public String getPhase() {
    return this.phase;
  }
  
  public A withPhase(String phase) {
    this.phase = phase;
    return (A) this;
  }
  
  public boolean hasPhase() {
    return this.phase != null;
  }
  
  public Integer getRunning() {
    return this.running;
  }
  
  public A withRunning(Integer running) {
    this.running = running;
    return (A) this;
  }
  
  public boolean hasRunning() {
    return this.running != null;
  }
  
  public Integer getSucceeded() {
    return this.succeeded;
  }
  
  public A withSucceeded(Integer succeeded) {
    this.succeeded = succeeded;
    return (A) this;
  }
  
  public boolean hasSucceeded() {
    return this.succeeded != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodGroupStatusFluent that = (PodGroupStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(failed, that.failed)) return false;
    if (!java.util.Objects.equals(phase, that.phase)) return false;
    if (!java.util.Objects.equals(running, that.running)) return false;
    if (!java.util.Objects.equals(succeeded, that.succeeded)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  failed,  phase,  running,  succeeded,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (failed != null) { sb.append("failed:"); sb.append(failed + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (running != null) { sb.append("running:"); sb.append(running + ","); }
    if (succeeded != null) { sb.append("succeeded:"); sb.append(succeeded); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends PodGroupConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,PodGroupCondition item) {
      this.index = index;
      this.builder = new PodGroupConditionBuilder(this, item);
    }
    PodGroupConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) PodGroupStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }

}