package io.fabric8.volcano.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VolcanoSchemaBuilder extends VolcanoSchemaFluent<VolcanoSchemaBuilder> implements VisitableBuilder<VolcanoSchema,VolcanoSchemaBuilder>{
  public VolcanoSchemaBuilder() {
    this(new VolcanoSchema());
  }
  
  public VolcanoSchemaBuilder(VolcanoSchemaFluent<?> fluent) {
    this(fluent, new VolcanoSchema());
  }
  
  public VolcanoSchemaBuilder(VolcanoSchemaFluent<?> fluent,VolcanoSchema instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VolcanoSchemaBuilder(VolcanoSchema instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VolcanoSchemaFluent<?> fluent;
  
  public VolcanoSchema build() {
    VolcanoSchema buildable = new VolcanoSchema(fluent.buildVolcanoShApisPkgApisSchedulingV1beta1PodGroup(),fluent.buildVolcanoShApisPkgApisSchedulingV1beta1PodGroupCondition(),fluent.buildVolcanoShApisPkgApisSchedulingV1beta1PodGroupList(),fluent.buildVolcanoShApisPkgApisSchedulingV1beta1PodGroupSpec(),fluent.buildVolcanoShApisPkgApisSchedulingV1beta1PodGroupStatus(),fluent.buildVolcanoShApisPkgApisSchedulingV1beta1Queue(),fluent.buildVolcanoShApisPkgApisSchedulingV1beta1QueueList(),fluent.buildVolcanoShApisPkgApisSchedulingV1beta1QueueSpec(),fluent.buildVolcanoShApisPkgApisSchedulingV1beta1QueueStatus());
    return buildable;
  }
  

}