/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.volcano.scheduling.v1beta1.QueueSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class QueueSpecFluent<A extends QueueSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Quantity> capability;
    private Boolean reclaimable;
    private Integer weight;

    public QueueSpecFluent() {
    }

    public QueueSpecFluent(QueueSpec instance) {
        QueueSpec queueSpec = instance = instance != null ? instance : new QueueSpec();
        if (instance != null) {
            this.withCapability(instance.getCapability());
            this.withReclaimable(instance.getReclaimable());
            this.withWeight(instance.getWeight());
            this.withCapability(instance.getCapability());
            this.withReclaimable(instance.getReclaimable());
            this.withWeight(instance.getWeight());
        }
    }

    public A addToCapability(String key, Quantity value) {
        if (this.capability == null && key != null && value != null) {
            this.capability = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.capability.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCapability(Map<String, Quantity> map) {
        if (this.capability == null && map != null) {
            this.capability = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.capability.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromCapability(String key) {
        if (this.capability == null) {
            return (A)((Object)this);
        }
        if (key != null && this.capability != null) {
            this.capability.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromCapability(Map<String, Quantity> map) {
        if (this.capability == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capability == null) continue;
                this.capability.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getCapability() {
        return this.capability;
    }

    public <K, V> A withCapability(Map<String, Quantity> capability) {
        this.capability = capability == null ? null : new LinkedHashMap<String, Quantity>(capability);
        return (A)((Object)this);
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    public Boolean getReclaimable() {
        return this.reclaimable;
    }

    public A withReclaimable(Boolean reclaimable) {
        this.reclaimable = reclaimable;
        return (A)((Object)this);
    }

    public boolean hasReclaimable() {
        return this.reclaimable != null;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public A withWeight(Integer weight) {
        this.weight = weight;
        return (A)((Object)this);
    }

    public boolean hasWeight() {
        return this.weight != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QueueSpecFluent that = (QueueSpecFluent)((Object)o);
        if (!Objects.equals(this.capability, that.capability)) {
            return false;
        }
        if (!Objects.equals(this.reclaimable, that.reclaimable)) {
            return false;
        }
        return Objects.equals(this.weight, that.weight);
    }

    public int hashCode() {
        return Objects.hash(this.capability, this.reclaimable, this.weight, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.capability != null && !this.capability.isEmpty()) {
            sb.append("capability:");
            sb.append(this.capability + ",");
        }
        if (this.reclaimable != null) {
            sb.append("reclaimable:");
            sb.append(this.reclaimable + ",");
        }
        if (this.weight != null) {
            sb.append("weight:");
            sb.append(this.weight);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReclaimable() {
        return this.withReclaimable(true);
    }
}

