package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QueueStatusBuilder extends QueueStatusFluent<QueueStatusBuilder> implements VisitableBuilder<QueueStatus,QueueStatusBuilder>{
  public QueueStatusBuilder() {
    this(false);
  }
  public QueueStatusBuilder(Boolean validationEnabled) {
    this(new QueueStatus(), validationEnabled);
  }
  public QueueStatusBuilder(QueueStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public QueueStatusBuilder(QueueStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new QueueStatus(), validationEnabled);
  }
  public QueueStatusBuilder(QueueStatusFluent<?> fluent,QueueStatus instance) {
    this(fluent, instance, false);
  }
  public QueueStatusBuilder(QueueStatusFluent<?> fluent,QueueStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new QueueStatus());

    if (instance != null) {
      fluent.withInqueue(instance.getInqueue());
      fluent.withPending(instance.getPending());
      fluent.withRunning(instance.getRunning());
      fluent.withState(instance.getState());
      fluent.withUnknown(instance.getUnknown());
      fluent.withInqueue(instance.getInqueue());
      fluent.withPending(instance.getPending());
      fluent.withRunning(instance.getRunning());
      fluent.withState(instance.getState());
      fluent.withUnknown(instance.getUnknown());
    }
    this.validationEnabled = validationEnabled; 
  }
  public QueueStatusBuilder(QueueStatus instance) {
    this(instance,false);
  }
  public QueueStatusBuilder(QueueStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new QueueStatus());

    if (instance != null) {
      this.withInqueue(instance.getInqueue());
      this.withPending(instance.getPending());
      this.withRunning(instance.getRunning());
      this.withState(instance.getState());
      this.withUnknown(instance.getUnknown());
      this.withInqueue(instance.getInqueue());
      this.withPending(instance.getPending());
      this.withRunning(instance.getRunning());
      this.withState(instance.getState());
      this.withUnknown(instance.getUnknown());
    }
    this.validationEnabled = validationEnabled; 
  }
  QueueStatusFluent<?> fluent;
  Boolean validationEnabled;
  public QueueStatus build() {
    QueueStatus buildable = new QueueStatus(fluent.getInqueue(),fluent.getPending(),fluent.getRunning(),fluent.getState(),fluent.getUnknown());
    return buildable;
  }
  
}