package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodGroupListBuilder extends PodGroupListFluent<PodGroupListBuilder> implements VisitableBuilder<PodGroupList,PodGroupListBuilder>{
  public PodGroupListBuilder() {
    this(false);
  }
  public PodGroupListBuilder(Boolean validationEnabled) {
    this(new PodGroupList(), validationEnabled);
  }
  public PodGroupListBuilder(PodGroupListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodGroupListBuilder(PodGroupListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodGroupList(), validationEnabled);
  }
  public PodGroupListBuilder(PodGroupListFluent<?> fluent,PodGroupList instance) {
    this(fluent, instance, false);
  }
  public PodGroupListBuilder(PodGroupListFluent<?> fluent,PodGroupList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodGroupList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodGroupListBuilder(PodGroupList instance) {
    this(instance,false);
  }
  public PodGroupListBuilder(PodGroupList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodGroupList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodGroupListFluent<?> fluent;
  Boolean validationEnabled;
  public PodGroupList build() {
    PodGroupList buildable = new PodGroupList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}