package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodGroupConditionBuilder extends PodGroupConditionFluent<PodGroupConditionBuilder> implements VisitableBuilder<PodGroupCondition,PodGroupConditionBuilder>{
  public PodGroupConditionBuilder() {
    this(false);
  }
  public PodGroupConditionBuilder(Boolean validationEnabled) {
    this(new PodGroupCondition(), validationEnabled);
  }
  public PodGroupConditionBuilder(PodGroupConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public PodGroupConditionBuilder(PodGroupConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodGroupCondition(), validationEnabled);
  }
  public PodGroupConditionBuilder(PodGroupConditionFluent<?> fluent,PodGroupCondition instance) {
    this(fluent, instance, false);
  }
  public PodGroupConditionBuilder(PodGroupConditionFluent<?> fluent,PodGroupCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodGroupCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withTransitionID(instance.getTransitionID());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withTransitionID(instance.getTransitionID());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodGroupConditionBuilder(PodGroupCondition instance) {
    this(instance,false);
  }
  public PodGroupConditionBuilder(PodGroupCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodGroupCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withTransitionID(instance.getTransitionID());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withTransitionID(instance.getTransitionID());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodGroupConditionFluent<?> fluent;
  Boolean validationEnabled;
  public PodGroupCondition build() {
    PodGroupCondition buildable = new PodGroupCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getTransitionID(),fluent.getType());
    return buildable;
  }
  
}