package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodGroupBuilder extends PodGroupFluent<PodGroupBuilder> implements VisitableBuilder<PodGroup,PodGroupBuilder>{
  public PodGroupBuilder() {
    this(false);
  }
  public PodGroupBuilder(Boolean validationEnabled) {
    this(new PodGroup(), validationEnabled);
  }
  public PodGroupBuilder(PodGroupFluent<?> fluent) {
    this(fluent, false);
  }
  public PodGroupBuilder(PodGroupFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodGroup(), validationEnabled);
  }
  public PodGroupBuilder(PodGroupFluent<?> fluent,PodGroup instance) {
    this(fluent, instance, false);
  }
  public PodGroupBuilder(PodGroupFluent<?> fluent,PodGroup instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodGroup());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodGroupBuilder(PodGroup instance) {
    this(instance,false);
  }
  public PodGroupBuilder(PodGroup instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodGroup());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodGroupFluent<?> fluent;
  Boolean validationEnabled;
  public PodGroup build() {
    PodGroup buildable = new PodGroup(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}