package io.fabric8.volcano.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolcanoSchemaBuilder extends VolcanoSchemaFluentImpl<VolcanoSchemaBuilder> implements VisitableBuilder<VolcanoSchema,VolcanoSchemaBuilder>{
  public VolcanoSchemaBuilder() {
    this(false);
  }
  public VolcanoSchemaBuilder(Boolean validationEnabled) {
    this(new VolcanoSchema(), validationEnabled);
  }
  public VolcanoSchemaBuilder(VolcanoSchemaFluent<?> fluent) {
    this(fluent, false);
  }
  public VolcanoSchemaBuilder(VolcanoSchemaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolcanoSchema(), validationEnabled);
  }
  public VolcanoSchemaBuilder(VolcanoSchemaFluent<?> fluent,VolcanoSchema instance) {
    this(fluent, instance, false);
  }
  public VolcanoSchemaBuilder(VolcanoSchemaFluent<?> fluent,VolcanoSchema instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withVolcanoShApisPkgApisSchedulingV1beta1PodGroup(instance.getVolcanoShApisPkgApisSchedulingV1beta1PodGroup());
      fluent.withVolcanoShApisPkgApisSchedulingV1beta1PodGroupCondition(instance.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupCondition());
      fluent.withVolcanoShApisPkgApisSchedulingV1beta1PodGroupList(instance.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupList());
      fluent.withVolcanoShApisPkgApisSchedulingV1beta1PodGroupSpec(instance.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupSpec());
      fluent.withVolcanoShApisPkgApisSchedulingV1beta1PodGroupStatus(instance.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupStatus());
      fluent.withVolcanoShApisPkgApisSchedulingV1beta1Queue(instance.getVolcanoShApisPkgApisSchedulingV1beta1Queue());
      fluent.withVolcanoShApisPkgApisSchedulingV1beta1QueueList(instance.getVolcanoShApisPkgApisSchedulingV1beta1QueueList());
      fluent.withVolcanoShApisPkgApisSchedulingV1beta1QueueSpec(instance.getVolcanoShApisPkgApisSchedulingV1beta1QueueSpec());
      fluent.withVolcanoShApisPkgApisSchedulingV1beta1QueueStatus(instance.getVolcanoShApisPkgApisSchedulingV1beta1QueueStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolcanoSchemaBuilder(VolcanoSchema instance) {
    this(instance,false);
  }
  public VolcanoSchemaBuilder(VolcanoSchema instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withVolcanoShApisPkgApisSchedulingV1beta1PodGroup(instance.getVolcanoShApisPkgApisSchedulingV1beta1PodGroup());
      this.withVolcanoShApisPkgApisSchedulingV1beta1PodGroupCondition(instance.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupCondition());
      this.withVolcanoShApisPkgApisSchedulingV1beta1PodGroupList(instance.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupList());
      this.withVolcanoShApisPkgApisSchedulingV1beta1PodGroupSpec(instance.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupSpec());
      this.withVolcanoShApisPkgApisSchedulingV1beta1PodGroupStatus(instance.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupStatus());
      this.withVolcanoShApisPkgApisSchedulingV1beta1Queue(instance.getVolcanoShApisPkgApisSchedulingV1beta1Queue());
      this.withVolcanoShApisPkgApisSchedulingV1beta1QueueList(instance.getVolcanoShApisPkgApisSchedulingV1beta1QueueList());
      this.withVolcanoShApisPkgApisSchedulingV1beta1QueueSpec(instance.getVolcanoShApisPkgApisSchedulingV1beta1QueueSpec());
      this.withVolcanoShApisPkgApisSchedulingV1beta1QueueStatus(instance.getVolcanoShApisPkgApisSchedulingV1beta1QueueStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolcanoSchemaFluent<?> fluent;
  Boolean validationEnabled;
  public VolcanoSchema build() {
    VolcanoSchema buildable = new VolcanoSchema(fluent.getVolcanoShApisPkgApisSchedulingV1beta1PodGroup(),fluent.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupCondition(),fluent.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupList(),fluent.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupSpec(),fluent.getVolcanoShApisPkgApisSchedulingV1beta1PodGroupStatus(),fluent.getVolcanoShApisPkgApisSchedulingV1beta1Queue(),fluent.getVolcanoShApisPkgApisSchedulingV1beta1QueueList(),fluent.getVolcanoShApisPkgApisSchedulingV1beta1QueueSpec(),fluent.getVolcanoShApisPkgApisSchedulingV1beta1QueueStatus());
    return buildable;
  }
  
}