/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.volcano.scheduling.v1beta1.PodGroupSpec;
import io.fabric8.volcano.scheduling.v1beta1.PodGroupSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PodGroupSpecFluentImpl<A extends PodGroupSpecFluent<A>>
extends BaseFluent<A>
implements PodGroupSpecFluent<A> {
    private Integer minMember;
    private Map<String, Quantity> minResources;
    private String priorityClassName;
    private String queue;

    public PodGroupSpecFluentImpl() {
    }

    public PodGroupSpecFluentImpl(PodGroupSpec instance) {
        if (instance != null) {
            this.withMinMember(instance.getMinMember());
            this.withMinResources(instance.getMinResources());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withQueue(instance.getQueue());
        }
    }

    @Override
    public Integer getMinMember() {
        return this.minMember;
    }

    @Override
    public A withMinMember(Integer minMember) {
        this.minMember = minMember;
        return (A)this;
    }

    @Override
    public Boolean hasMinMember() {
        return this.minMember != null;
    }

    @Override
    public A addToMinResources(String key, Quantity value) {
        if (this.minResources == null && key != null && value != null) {
            this.minResources = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.minResources.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMinResources(Map<String, Quantity> map) {
        if (this.minResources == null && map != null) {
            this.minResources = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.minResources.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMinResources(String key) {
        if (this.minResources == null) {
            return (A)this;
        }
        if (key != null && this.minResources != null) {
            this.minResources.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMinResources(Map<String, Quantity> map) {
        if (this.minResources == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.minResources == null) continue;
                this.minResources.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getMinResources() {
        return this.minResources;
    }

    @Override
    public <K, V> A withMinResources(Map<String, Quantity> minResources) {
        this.minResources = minResources == null ? null : new LinkedHashMap<String, Quantity>(minResources);
        return (A)this;
    }

    @Override
    public Boolean hasMinResources() {
        return this.minResources != null;
    }

    @Override
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    @Override
    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    @Override
    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    @Override
    public A withQueue(String queue) {
        this.queue = queue;
        return (A)this;
    }

    @Override
    public Boolean hasQueue() {
        return this.queue != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodGroupSpecFluentImpl that = (PodGroupSpecFluentImpl)o;
        if (!Objects.equals(this.minMember, that.minMember)) {
            return false;
        }
        if (!Objects.equals(this.minResources, that.minResources)) {
            return false;
        }
        if (!Objects.equals(this.priorityClassName, that.priorityClassName)) {
            return false;
        }
        return Objects.equals(this.queue, that.queue);
    }

    public int hashCode() {
        return Objects.hash(this.minMember, this.minResources, this.priorityClassName, this.queue, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minMember != null) {
            sb.append("minMember:");
            sb.append(this.minMember + ",");
        }
        if (this.minResources != null && !this.minResources.isEmpty()) {
            sb.append("minResources:");
            sb.append(this.minResources + ",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName + ",");
        }
        if (this.queue != null) {
            sb.append("queue:");
            sb.append(this.queue);
        }
        sb.append("}");
        return sb.toString();
    }
}

