package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QueueBuilder extends QueueFluentImpl<QueueBuilder> implements VisitableBuilder<Queue,QueueBuilder>{
  public QueueBuilder() {
    this(false);
  }
  public QueueBuilder(Boolean validationEnabled) {
    this(new Queue(), validationEnabled);
  }
  public QueueBuilder(QueueFluent<?> fluent) {
    this(fluent, false);
  }
  public QueueBuilder(QueueFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Queue(), validationEnabled);
  }
  public QueueBuilder(QueueFluent<?> fluent,Queue instance) {
    this(fluent, instance, false);
  }
  public QueueBuilder(QueueFluent<?> fluent,Queue instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public QueueBuilder(Queue instance) {
    this(instance,false);
  }
  public QueueBuilder(Queue instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  QueueFluent<?> fluent;
  Boolean validationEnabled;
  public Queue build() {
    Queue buildable = new Queue(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}