package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodGroupStatusBuilder extends PodGroupStatusFluentImpl<PodGroupStatusBuilder> implements VisitableBuilder<PodGroupStatus,PodGroupStatusBuilder>{
  public PodGroupStatusBuilder() {
    this(false);
  }
  public PodGroupStatusBuilder(Boolean validationEnabled) {
    this(new PodGroupStatus(), validationEnabled);
  }
  public PodGroupStatusBuilder(PodGroupStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodGroupStatusBuilder(PodGroupStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodGroupStatus(), validationEnabled);
  }
  public PodGroupStatusBuilder(PodGroupStatusFluent<?> fluent,PodGroupStatus instance) {
    this(fluent, instance, false);
  }
  public PodGroupStatusBuilder(PodGroupStatusFluent<?> fluent,PodGroupStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withFailed(instance.getFailed()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withRunning(instance.getRunning()); 
    fluent.withSucceeded(instance.getSucceeded()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodGroupStatusBuilder(PodGroupStatus instance) {
    this(instance,false);
  }
  public PodGroupStatusBuilder(PodGroupStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withFailed(instance.getFailed()); 
    this.withPhase(instance.getPhase()); 
    this.withRunning(instance.getRunning()); 
    this.withSucceeded(instance.getSucceeded()); 
    this.validationEnabled = validationEnabled; 
  }
  PodGroupStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodGroupStatus build() {
    PodGroupStatus buildable = new PodGroupStatus(fluent.getConditions(),fluent.getFailed(),fluent.getPhase(),fluent.getRunning(),fluent.getSucceeded());
    return buildable;
  }
  
}