package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QueueListBuilder extends QueueListFluentImpl<QueueListBuilder> implements VisitableBuilder<QueueList,QueueListBuilder>{
  public QueueListBuilder() {
    this(false);
  }
  public QueueListBuilder(Boolean validationEnabled) {
    this(new QueueList(), validationEnabled);
  }
  public QueueListBuilder(QueueListFluent<?> fluent) {
    this(fluent, false);
  }
  public QueueListBuilder(QueueListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new QueueList(), validationEnabled);
  }
  public QueueListBuilder(QueueListFluent<?> fluent,QueueList instance) {
    this(fluent, instance, false);
  }
  public QueueListBuilder(QueueListFluent<?> fluent,QueueList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public QueueListBuilder(QueueList instance) {
    this(instance,false);
  }
  public QueueListBuilder(QueueList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  QueueListFluent<?> fluent;
  Boolean validationEnabled;
  public QueueList build() {
    QueueList buildable = new QueueList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}