package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodGroupStatusBuilder extends PodGroupStatusFluent<PodGroupStatusBuilder> implements VisitableBuilder<PodGroupStatus,PodGroupStatusBuilder>{
  public PodGroupStatusBuilder() {
    this(new PodGroupStatus());
  }
  
  public PodGroupStatusBuilder(PodGroupStatusFluent<?> fluent) {
    this(fluent, new PodGroupStatus());
  }
  
  public PodGroupStatusBuilder(PodGroupStatusFluent<?> fluent,PodGroupStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodGroupStatusBuilder(PodGroupStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodGroupStatusFluent<?> fluent;
  
  public PodGroupStatus build() {
    PodGroupStatus buildable = new PodGroupStatus(fluent.buildConditions(),fluent.getFailed(),fluent.getPhase(),fluent.getRunning(),fluent.getSucceeded());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}