package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QueueListBuilder extends QueueListFluent<QueueListBuilder> implements VisitableBuilder<QueueList,QueueListBuilder>{
  public QueueListBuilder() {
    this(new QueueList());
  }
  
  public QueueListBuilder(QueueListFluent<?> fluent) {
    this(fluent, new QueueList());
  }
  
  public QueueListBuilder(QueueListFluent<?> fluent,QueueList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QueueListBuilder(QueueList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QueueListFluent<?> fluent;
  
  public QueueList build() {
    QueueList buildable = new QueueList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}