package io.fabric8.volcano.scheduling.v1beta1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class QueueSpecFluent<A extends QueueSpecFluent<A>> extends BaseFluent<A>{
  public QueueSpecFluent() {
  }
  
  public QueueSpecFluent(QueueSpec instance) {
    this.copyInstance(instance);
  }
  private Map<String,Quantity> capability;
  private Boolean reclaimable;
  private Integer weight;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(QueueSpec instance) {
    instance = (instance != null ? instance : new QueueSpec());
    if (instance != null) {
          this.withCapability(instance.getCapability());
          this.withReclaimable(instance.getReclaimable());
          this.withWeight(instance.getWeight());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToCapability(String key,Quantity value) {
    if(this.capability == null && key != null && value != null) { this.capability = new LinkedHashMap(); }
    if(key != null && value != null) {this.capability.put(key, value);} return (A)this;
  }
  
  public A addToCapability(Map<String,Quantity> map) {
    if(this.capability == null && map != null) { this.capability = new LinkedHashMap(); }
    if(map != null) { this.capability.putAll(map);} return (A)this;
  }
  
  public A removeFromCapability(String key) {
    if(this.capability == null) { return (A) this; }
    if(key != null && this.capability != null) {this.capability.remove(key);} return (A)this;
  }
  
  public A removeFromCapability(Map<String,Quantity> map) {
    if(this.capability == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capability != null){this.capability.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getCapability() {
    return this.capability;
  }
  
  public <K,V>A withCapability(Map<String,Quantity> capability) {
    if (capability == null) {
      this.capability = null;
    } else {
      this.capability = new LinkedHashMap(capability);
    }
    return (A) this;
  }
  
  public boolean hasCapability() {
    return this.capability != null;
  }
  
  public Boolean getReclaimable() {
    return this.reclaimable;
  }
  
  public A withReclaimable(Boolean reclaimable) {
    this.reclaimable = reclaimable;
    return (A) this;
  }
  
  public boolean hasReclaimable() {
    return this.reclaimable != null;
  }
  
  public Integer getWeight() {
    return this.weight;
  }
  
  public A withWeight(Integer weight) {
    this.weight = weight;
    return (A) this;
  }
  
  public boolean hasWeight() {
    return this.weight != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    QueueSpecFluent that = (QueueSpecFluent) o;
    if (!java.util.Objects.equals(capability, that.capability)) return false;
    if (!java.util.Objects.equals(reclaimable, that.reclaimable)) return false;
    if (!java.util.Objects.equals(weight, that.weight)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(capability,  reclaimable,  weight,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (capability != null && !capability.isEmpty()) { sb.append("capability:"); sb.append(capability + ","); }
    if (reclaimable != null) { sb.append("reclaimable:"); sb.append(reclaimable + ","); }
    if (weight != null) { sb.append("weight:"); sb.append(weight + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReclaimable() {
    return withReclaimable(true);
  }
  

}