package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodGroupBuilder extends PodGroupFluent<PodGroupBuilder> implements VisitableBuilder<PodGroup,PodGroupBuilder>{
  public PodGroupBuilder() {
    this(new PodGroup());
  }
  
  public PodGroupBuilder(PodGroupFluent<?> fluent) {
    this(fluent, new PodGroup());
  }
  
  public PodGroupBuilder(PodGroupFluent<?> fluent,PodGroup instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodGroupBuilder(PodGroup instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodGroupFluent<?> fluent;
  
  public PodGroup build() {
    PodGroup buildable = new PodGroup(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}