package io.fabric8.volcano.scheduling.v1beta1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodGroupSpecFluentImpl<A extends PodGroupSpecFluent<A>> extends BaseFluent<A> implements PodGroupSpecFluent<A>{
  public PodGroupSpecFluentImpl() {
  }
  public PodGroupSpecFluentImpl(PodGroupSpec instance) {
    this.withMinMember(instance.getMinMember()); 
    this.withMinResources(instance.getMinResources()); 
    this.withPriorityClassName(instance.getPriorityClassName()); 
    this.withQueue(instance.getQueue()); 
  }
  private Integer minMember;
  private Map<String,Quantity> minResources;
  private String priorityClassName;
  private String queue;
  public Integer getMinMember() {
    return this.minMember;
  }
  public A withMinMember(Integer minMember) {
    this.minMember=minMember; return (A) this;
  }
  public Boolean hasMinMember() {
    return this.minMember != null;
  }
  public A addToMinResources(String key,Quantity value) {
    if(this.minResources == null && key != null && value != null) { this.minResources = new LinkedHashMap(); }
    if(key != null && value != null) {this.minResources.put(key, value);} return (A)this;
  }
  public A addToMinResources(Map<String,Quantity> map) {
    if(this.minResources == null && map != null) { this.minResources = new LinkedHashMap(); }
    if(map != null) { this.minResources.putAll(map);} return (A)this;
  }
  public A removeFromMinResources(String key) {
    if(this.minResources == null) { return (A) this; }
    if(key != null && this.minResources != null) {this.minResources.remove(key);} return (A)this;
  }
  public A removeFromMinResources(Map<String,Quantity> map) {
    if(this.minResources == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.minResources != null){this.minResources.remove(key);}}} return (A)this;
  }
  public Map<String,Quantity> getMinResources() {
    return this.minResources;
  }
  public <K,V>A withMinResources(Map<String,Quantity> minResources) {
    if (minResources == null) { this.minResources =  null;} else {this.minResources = new LinkedHashMap(minResources);} return (A) this;
  }
  public Boolean hasMinResources() {
    return this.minResources != null;
  }
  public String getPriorityClassName() {
    return this.priorityClassName;
  }
  public A withPriorityClassName(String priorityClassName) {
    this.priorityClassName=priorityClassName; return (A) this;
  }
  public Boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  public String getQueue() {
    return this.queue;
  }
  public A withQueue(String queue) {
    this.queue=queue; return (A) this;
  }
  public Boolean hasQueue() {
    return this.queue != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodGroupSpecFluentImpl that = (PodGroupSpecFluentImpl) o;
    if (minMember != null ? !minMember.equals(that.minMember) :that.minMember != null) return false;
    if (minResources != null ? !minResources.equals(that.minResources) :that.minResources != null) return false;
    if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
    if (queue != null ? !queue.equals(that.queue) :that.queue != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minMember,  minResources,  priorityClassName,  queue,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minMember != null) { sb.append("minMember:"); sb.append(minMember + ","); }
    if (minResources != null && !minResources.isEmpty()) { sb.append("minResources:"); sb.append(minResources + ","); }
    if (priorityClassName != null) { sb.append("priorityClassName:"); sb.append(priorityClassName + ","); }
    if (queue != null) { sb.append("queue:"); sb.append(queue); }
    sb.append("}");
    return sb.toString();
  }
  
}