package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodGroupSpecBuilder extends PodGroupSpecFluentImpl<PodGroupSpecBuilder> implements VisitableBuilder<PodGroupSpec,PodGroupSpecBuilder>{
  public PodGroupSpecBuilder() {
    this(false);
  }
  public PodGroupSpecBuilder(Boolean validationEnabled) {
    this(new PodGroupSpec(), validationEnabled);
  }
  public PodGroupSpecBuilder(PodGroupSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodGroupSpecBuilder(PodGroupSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodGroupSpec(), validationEnabled);
  }
  public PodGroupSpecBuilder(PodGroupSpecFluent<?> fluent,PodGroupSpec instance) {
    this(fluent, instance, false);
  }
  public PodGroupSpecBuilder(PodGroupSpecFluent<?> fluent,PodGroupSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinMember(instance.getMinMember()); 
    fluent.withMinResources(instance.getMinResources()); 
    fluent.withPriorityClassName(instance.getPriorityClassName()); 
    fluent.withQueue(instance.getQueue()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodGroupSpecBuilder(PodGroupSpec instance) {
    this(instance,false);
  }
  public PodGroupSpecBuilder(PodGroupSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinMember(instance.getMinMember()); 
    this.withMinResources(instance.getMinResources()); 
    this.withPriorityClassName(instance.getPriorityClassName()); 
    this.withQueue(instance.getQueue()); 
    this.validationEnabled = validationEnabled; 
  }
  PodGroupSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodGroupSpec build() {
    PodGroupSpec buildable = new PodGroupSpec(fluent.getMinMember(),fluent.getMinResources(),fluent.getPriorityClassName(),fluent.getQueue());
    return buildable;
  }
  
}