/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.verticalpodautoscaler.api.model.v1.ContainerResourcePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ContainerResourcePolicyFluent<A extends ContainerResourcePolicyFluent<A>>
extends BaseFluent<A> {
    private String containerName;
    private List<String> controlledResources = new ArrayList<String>();
    private String controlledValues;
    private Map<String, Quantity> maxAllowed;
    private Map<String, Quantity> minAllowed;
    private String mode;

    public ContainerResourcePolicyFluent() {
    }

    public ContainerResourcePolicyFluent(ContainerResourcePolicy instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ContainerResourcePolicy instance) {
        ContainerResourcePolicy containerResourcePolicy = instance = instance != null ? instance : new ContainerResourcePolicy();
        if (instance != null) {
            this.withContainerName(instance.getContainerName());
            this.withControlledResources(instance.getControlledResources());
            this.withControlledValues(instance.getControlledValues());
            this.withMaxAllowed(instance.getMaxAllowed());
            this.withMinAllowed(instance.getMinAllowed());
            this.withMode(instance.getMode());
            this.withContainerName(instance.getContainerName());
            this.withControlledResources(instance.getControlledResources());
            this.withControlledValues(instance.getControlledValues());
            this.withMaxAllowed(instance.getMaxAllowed());
            this.withMinAllowed(instance.getMinAllowed());
            this.withMode(instance.getMode());
        }
    }

    public String getContainerName() {
        return this.containerName;
    }

    public A withContainerName(String containerName) {
        this.containerName = containerName;
        return (A)((Object)this);
    }

    public boolean hasContainerName() {
        return this.containerName != null;
    }

    public A addToControlledResources(int index, String item) {
        if (this.controlledResources == null) {
            this.controlledResources = new ArrayList<String>();
        }
        this.controlledResources.add(index, item);
        return (A)((Object)this);
    }

    public A setToControlledResources(int index, String item) {
        if (this.controlledResources == null) {
            this.controlledResources = new ArrayList<String>();
        }
        this.controlledResources.set(index, item);
        return (A)((Object)this);
    }

    public A addToControlledResources(String ... items) {
        if (this.controlledResources == null) {
            this.controlledResources = new ArrayList<String>();
        }
        for (String item : items) {
            this.controlledResources.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToControlledResources(Collection<String> items) {
        if (this.controlledResources == null) {
            this.controlledResources = new ArrayList<String>();
        }
        for (String item : items) {
            this.controlledResources.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromControlledResources(String ... items) {
        if (this.controlledResources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.controlledResources.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromControlledResources(Collection<String> items) {
        if (this.controlledResources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.controlledResources.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getControlledResources() {
        return this.controlledResources;
    }

    public String getControlledResource(int index) {
        return this.controlledResources.get(index);
    }

    public String getFirstControlledResource() {
        return this.controlledResources.get(0);
    }

    public String getLastControlledResource() {
        return this.controlledResources.get(this.controlledResources.size() - 1);
    }

    public String getMatchingControlledResource(Predicate<String> predicate) {
        for (String item : this.controlledResources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingControlledResource(Predicate<String> predicate) {
        for (String item : this.controlledResources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withControlledResources(List<String> controlledResources) {
        if (controlledResources != null) {
            this.controlledResources = new ArrayList<String>();
            for (String item : controlledResources) {
                this.addToControlledResources(item);
            }
        } else {
            this.controlledResources = null;
        }
        return (A)((Object)this);
    }

    public A withControlledResources(String ... controlledResources) {
        if (this.controlledResources != null) {
            this.controlledResources.clear();
            this._visitables.remove((Object)"controlledResources");
        }
        if (controlledResources != null) {
            for (String item : controlledResources) {
                this.addToControlledResources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasControlledResources() {
        return this.controlledResources != null && !this.controlledResources.isEmpty();
    }

    public String getControlledValues() {
        return this.controlledValues;
    }

    public A withControlledValues(String controlledValues) {
        this.controlledValues = controlledValues;
        return (A)((Object)this);
    }

    public boolean hasControlledValues() {
        return this.controlledValues != null;
    }

    public A addToMaxAllowed(String key, Quantity value) {
        if (this.maxAllowed == null && key != null && value != null) {
            this.maxAllowed = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.maxAllowed.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMaxAllowed(Map<String, Quantity> map) {
        if (this.maxAllowed == null && map != null) {
            this.maxAllowed = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.maxAllowed.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromMaxAllowed(String key) {
        if (this.maxAllowed == null) {
            return (A)((Object)this);
        }
        if (key != null && this.maxAllowed != null) {
            this.maxAllowed.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromMaxAllowed(Map<String, Quantity> map) {
        if (this.maxAllowed == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.maxAllowed == null) continue;
                this.maxAllowed.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getMaxAllowed() {
        return this.maxAllowed;
    }

    public <K, V> A withMaxAllowed(Map<String, Quantity> maxAllowed) {
        this.maxAllowed = maxAllowed == null ? null : new LinkedHashMap<String, Quantity>(maxAllowed);
        return (A)((Object)this);
    }

    public boolean hasMaxAllowed() {
        return this.maxAllowed != null;
    }

    public A addToMinAllowed(String key, Quantity value) {
        if (this.minAllowed == null && key != null && value != null) {
            this.minAllowed = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.minAllowed.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMinAllowed(Map<String, Quantity> map) {
        if (this.minAllowed == null && map != null) {
            this.minAllowed = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.minAllowed.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromMinAllowed(String key) {
        if (this.minAllowed == null) {
            return (A)((Object)this);
        }
        if (key != null && this.minAllowed != null) {
            this.minAllowed.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromMinAllowed(Map<String, Quantity> map) {
        if (this.minAllowed == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.minAllowed == null) continue;
                this.minAllowed.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Quantity> getMinAllowed() {
        return this.minAllowed;
    }

    public <K, V> A withMinAllowed(Map<String, Quantity> minAllowed) {
        this.minAllowed = minAllowed == null ? null : new LinkedHashMap<String, Quantity>(minAllowed);
        return (A)((Object)this);
    }

    public boolean hasMinAllowed() {
        return this.minAllowed != null;
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerResourcePolicyFluent that = (ContainerResourcePolicyFluent)((Object)o);
        if (!Objects.equals(this.containerName, that.containerName)) {
            return false;
        }
        if (!Objects.equals(this.controlledResources, that.controlledResources)) {
            return false;
        }
        if (!Objects.equals(this.controlledValues, that.controlledValues)) {
            return false;
        }
        if (!Objects.equals(this.maxAllowed, that.maxAllowed)) {
            return false;
        }
        if (!Objects.equals(this.minAllowed, that.minAllowed)) {
            return false;
        }
        return Objects.equals(this.mode, that.mode);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.controlledResources, this.controlledValues, this.maxAllowed, this.minAllowed, this.mode, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerName != null) {
            sb.append("containerName:");
            sb.append(this.containerName + ",");
        }
        if (this.controlledResources != null && !this.controlledResources.isEmpty()) {
            sb.append("controlledResources:");
            sb.append(this.controlledResources + ",");
        }
        if (this.controlledValues != null) {
            sb.append("controlledValues:");
            sb.append(this.controlledValues + ",");
        }
        if (this.maxAllowed != null && !this.maxAllowed.isEmpty()) {
            sb.append("maxAllowed:");
            sb.append(this.maxAllowed + ",");
        }
        if (this.minAllowed != null && !this.minAllowed.isEmpty()) {
            sb.append("minAllowed:");
            sb.append(this.minAllowed + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode);
        }
        sb.append("}");
        return sb.toString();
    }
}

