package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VerticalPodAutoscalerSpecBuilder extends VerticalPodAutoscalerSpecFluent<VerticalPodAutoscalerSpecBuilder> implements VisitableBuilder<VerticalPodAutoscalerSpec,VerticalPodAutoscalerSpecBuilder>{
  public VerticalPodAutoscalerSpecBuilder() {
    this(false);
  }
  public VerticalPodAutoscalerSpecBuilder(Boolean validationEnabled) {
    this(new VerticalPodAutoscalerSpec(), validationEnabled);
  }
  public VerticalPodAutoscalerSpecBuilder(VerticalPodAutoscalerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public VerticalPodAutoscalerSpecBuilder(VerticalPodAutoscalerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VerticalPodAutoscalerSpec(), validationEnabled);
  }
  public VerticalPodAutoscalerSpecBuilder(VerticalPodAutoscalerSpecFluent<?> fluent,VerticalPodAutoscalerSpec instance) {
    this(fluent, instance, false);
  }
  public VerticalPodAutoscalerSpecBuilder(VerticalPodAutoscalerSpecFluent<?> fluent,VerticalPodAutoscalerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VerticalPodAutoscalerSpec());

    if (instance != null) {
      fluent.withResourcePolicy(instance.getResourcePolicy());
      fluent.withTargetRef(instance.getTargetRef());
      fluent.withUpdatePolicy(instance.getUpdatePolicy());
      fluent.withResourcePolicy(instance.getResourcePolicy());
      fluent.withTargetRef(instance.getTargetRef());
      fluent.withUpdatePolicy(instance.getUpdatePolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VerticalPodAutoscalerSpecBuilder(VerticalPodAutoscalerSpec instance) {
    this(instance,false);
  }
  public VerticalPodAutoscalerSpecBuilder(VerticalPodAutoscalerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VerticalPodAutoscalerSpec());

    if (instance != null) {
      this.withResourcePolicy(instance.getResourcePolicy());
      this.withTargetRef(instance.getTargetRef());
      this.withUpdatePolicy(instance.getUpdatePolicy());
      this.withResourcePolicy(instance.getResourcePolicy());
      this.withTargetRef(instance.getTargetRef());
      this.withUpdatePolicy(instance.getUpdatePolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  VerticalPodAutoscalerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public VerticalPodAutoscalerSpec build() {
    VerticalPodAutoscalerSpec buildable = new VerticalPodAutoscalerSpec(fluent.buildResourcePolicy(),fluent.getTargetRef(),fluent.buildUpdatePolicy());
    return buildable;
  }
  
}