package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VerticalPodAutoscalerBuilder extends VerticalPodAutoscalerFluent<VerticalPodAutoscalerBuilder> implements VisitableBuilder<VerticalPodAutoscaler,VerticalPodAutoscalerBuilder>{
  public VerticalPodAutoscalerBuilder() {
    this(false);
  }
  public VerticalPodAutoscalerBuilder(Boolean validationEnabled) {
    this(new VerticalPodAutoscaler(), validationEnabled);
  }
  public VerticalPodAutoscalerBuilder(VerticalPodAutoscalerFluent<?> fluent) {
    this(fluent, false);
  }
  public VerticalPodAutoscalerBuilder(VerticalPodAutoscalerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VerticalPodAutoscaler(), validationEnabled);
  }
  public VerticalPodAutoscalerBuilder(VerticalPodAutoscalerFluent<?> fluent,VerticalPodAutoscaler instance) {
    this(fluent, instance, false);
  }
  public VerticalPodAutoscalerBuilder(VerticalPodAutoscalerFluent<?> fluent,VerticalPodAutoscaler instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VerticalPodAutoscaler());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VerticalPodAutoscalerBuilder(VerticalPodAutoscaler instance) {
    this(instance,false);
  }
  public VerticalPodAutoscalerBuilder(VerticalPodAutoscaler instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VerticalPodAutoscaler());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  VerticalPodAutoscalerFluent<?> fluent;
  Boolean validationEnabled;
  public VerticalPodAutoscaler build() {
    VerticalPodAutoscaler buildable = new VerticalPodAutoscaler(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}