/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference;
import io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicy;
import io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicyBuilder;
import io.fabric8.verticalpodautoscaler.api.model.v1.PodResourcePolicyFluent;
import io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicy;
import io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicyBuilder;
import io.fabric8.verticalpodautoscaler.api.model.v1.PodUpdatePolicyFluent;
import io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerSpec;
import java.util.Objects;
import java.util.Optional;

public class VerticalPodAutoscalerSpecFluent<A extends VerticalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private PodResourcePolicyBuilder resourcePolicy;
    private CrossVersionObjectReference targetRef;
    private PodUpdatePolicyBuilder updatePolicy;

    public VerticalPodAutoscalerSpecFluent() {
    }

    public VerticalPodAutoscalerSpecFluent(VerticalPodAutoscalerSpec instance) {
        VerticalPodAutoscalerSpec verticalPodAutoscalerSpec = instance = instance != null ? instance : new VerticalPodAutoscalerSpec();
        if (instance != null) {
            this.withResourcePolicy(instance.getResourcePolicy());
            this.withTargetRef(instance.getTargetRef());
            this.withUpdatePolicy(instance.getUpdatePolicy());
            this.withResourcePolicy(instance.getResourcePolicy());
            this.withTargetRef(instance.getTargetRef());
            this.withUpdatePolicy(instance.getUpdatePolicy());
        }
    }

    public PodResourcePolicy buildResourcePolicy() {
        return this.resourcePolicy != null ? this.resourcePolicy.build() : null;
    }

    public A withResourcePolicy(PodResourcePolicy resourcePolicy) {
        this._visitables.get((Object)"resourcePolicy").remove((Object)this.resourcePolicy);
        if (resourcePolicy != null) {
            this.resourcePolicy = new PodResourcePolicyBuilder(resourcePolicy);
            this._visitables.get((Object)"resourcePolicy").add(this.resourcePolicy);
        } else {
            this.resourcePolicy = null;
            this._visitables.get((Object)"resourcePolicy").remove((Object)this.resourcePolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasResourcePolicy() {
        return this.resourcePolicy != null;
    }

    public ResourcePolicyNested<A> withNewResourcePolicy() {
        return new ResourcePolicyNested(null);
    }

    public ResourcePolicyNested<A> withNewResourcePolicyLike(PodResourcePolicy item) {
        return new ResourcePolicyNested(item);
    }

    public ResourcePolicyNested<A> editResourcePolicy() {
        return this.withNewResourcePolicyLike(Optional.ofNullable(this.buildResourcePolicy()).orElse(null));
    }

    public ResourcePolicyNested<A> editOrNewResourcePolicy() {
        return this.withNewResourcePolicyLike(Optional.ofNullable(this.buildResourcePolicy()).orElse(new PodResourcePolicyBuilder().build()));
    }

    public ResourcePolicyNested<A> editOrNewResourcePolicyLike(PodResourcePolicy item) {
        return this.withNewResourcePolicyLike(Optional.ofNullable(this.buildResourcePolicy()).orElse(item));
    }

    public CrossVersionObjectReference getTargetRef() {
        return this.targetRef;
    }

    public A withTargetRef(CrossVersionObjectReference targetRef) {
        this.targetRef = targetRef;
        return (A)((Object)this);
    }

    public boolean hasTargetRef() {
        return this.targetRef != null;
    }

    public A withNewTargetRef(String apiVersion, String kind, String name) {
        return this.withTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public PodUpdatePolicy buildUpdatePolicy() {
        return this.updatePolicy != null ? this.updatePolicy.build() : null;
    }

    public A withUpdatePolicy(PodUpdatePolicy updatePolicy) {
        this._visitables.get((Object)"updatePolicy").remove((Object)this.updatePolicy);
        if (updatePolicy != null) {
            this.updatePolicy = new PodUpdatePolicyBuilder(updatePolicy);
            this._visitables.get((Object)"updatePolicy").add(this.updatePolicy);
        } else {
            this.updatePolicy = null;
            this._visitables.get((Object)"updatePolicy").remove((Object)this.updatePolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasUpdatePolicy() {
        return this.updatePolicy != null;
    }

    public A withNewUpdatePolicy(String updateMode) {
        return this.withUpdatePolicy(new PodUpdatePolicy(updateMode));
    }

    public UpdatePolicyNested<A> withNewUpdatePolicy() {
        return new UpdatePolicyNested(null);
    }

    public UpdatePolicyNested<A> withNewUpdatePolicyLike(PodUpdatePolicy item) {
        return new UpdatePolicyNested(item);
    }

    public UpdatePolicyNested<A> editUpdatePolicy() {
        return this.withNewUpdatePolicyLike(Optional.ofNullable(this.buildUpdatePolicy()).orElse(null));
    }

    public UpdatePolicyNested<A> editOrNewUpdatePolicy() {
        return this.withNewUpdatePolicyLike(Optional.ofNullable(this.buildUpdatePolicy()).orElse(new PodUpdatePolicyBuilder().build()));
    }

    public UpdatePolicyNested<A> editOrNewUpdatePolicyLike(PodUpdatePolicy item) {
        return this.withNewUpdatePolicyLike(Optional.ofNullable(this.buildUpdatePolicy()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VerticalPodAutoscalerSpecFluent that = (VerticalPodAutoscalerSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.resourcePolicy, (Object)that.resourcePolicy)) {
            return false;
        }
        if (!Objects.equals(this.targetRef, that.targetRef)) {
            return false;
        }
        return Objects.equals((Object)this.updatePolicy, (Object)that.updatePolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourcePolicy, this.targetRef, this.updatePolicy, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourcePolicy != null) {
            sb.append("resourcePolicy:");
            sb.append((Object)((Object)this.resourcePolicy) + ",");
        }
        if (this.targetRef != null) {
            sb.append("targetRef:");
            sb.append(this.targetRef + ",");
        }
        if (this.updatePolicy != null) {
            sb.append("updatePolicy:");
            sb.append((Object)this.updatePolicy);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UpdatePolicyNested<N>
    extends PodUpdatePolicyFluent<UpdatePolicyNested<N>>
    implements Nested<N> {
        PodUpdatePolicyBuilder builder;

        UpdatePolicyNested(PodUpdatePolicy item) {
            this.builder = new PodUpdatePolicyBuilder(this, item);
        }

        public N and() {
            return (N)VerticalPodAutoscalerSpecFluent.this.withUpdatePolicy(this.builder.build());
        }

        public N endUpdatePolicy() {
            return this.and();
        }
    }

    public class ResourcePolicyNested<N>
    extends PodResourcePolicyFluent<ResourcePolicyNested<N>>
    implements Nested<N> {
        PodResourcePolicyBuilder builder;

        ResourcePolicyNested(PodResourcePolicy item) {
            this.builder = new PodResourcePolicyBuilder(this, item);
        }

        public N and() {
            return (N)VerticalPodAutoscalerSpecFluent.this.withResourcePolicy(this.builder.build());
        }

        public N endResourcePolicy() {
            return this.and();
        }
    }
}

