/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.verticalpodautoscaler.api.model.v1.HistogramCheckpoint;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class HistogramCheckpointFluent<A extends HistogramCheckpointFluent<A>>
extends BaseFluent<A> {
    private Map<Integer, Long> bucketWeights;
    private String referenceTimestamp;
    private Double totalWeight;

    public HistogramCheckpointFluent() {
    }

    public HistogramCheckpointFluent(HistogramCheckpoint instance) {
        HistogramCheckpoint histogramCheckpoint = instance = instance != null ? instance : new HistogramCheckpoint();
        if (instance != null) {
            this.withBucketWeights(instance.getBucketWeights());
            this.withReferenceTimestamp(instance.getReferenceTimestamp());
            this.withTotalWeight(instance.getTotalWeight());
            this.withBucketWeights(instance.getBucketWeights());
            this.withReferenceTimestamp(instance.getReferenceTimestamp());
            this.withTotalWeight(instance.getTotalWeight());
        }
    }

    public A addToBucketWeights(Integer key, Long value) {
        if (this.bucketWeights == null && key != null && value != null) {
            this.bucketWeights = new LinkedHashMap<Integer, Long>();
        }
        if (key != null && value != null) {
            this.bucketWeights.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToBucketWeights(Map<Integer, Long> map) {
        if (this.bucketWeights == null && map != null) {
            this.bucketWeights = new LinkedHashMap<Integer, Long>();
        }
        if (map != null) {
            this.bucketWeights.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromBucketWeights(Integer key) {
        if (this.bucketWeights == null) {
            return (A)((Object)this);
        }
        if (key != null && this.bucketWeights != null) {
            this.bucketWeights.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromBucketWeights(Map<Integer, Long> map) {
        if (this.bucketWeights == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (Integer key : map.keySet()) {
                if (this.bucketWeights == null) continue;
                this.bucketWeights.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<Integer, Long> getBucketWeights() {
        return this.bucketWeights;
    }

    public <K, V> A withBucketWeights(Map<Integer, Long> bucketWeights) {
        this.bucketWeights = bucketWeights == null ? null : new LinkedHashMap<Integer, Long>(bucketWeights);
        return (A)((Object)this);
    }

    public boolean hasBucketWeights() {
        return this.bucketWeights != null;
    }

    public String getReferenceTimestamp() {
        return this.referenceTimestamp;
    }

    public A withReferenceTimestamp(String referenceTimestamp) {
        this.referenceTimestamp = referenceTimestamp;
        return (A)((Object)this);
    }

    public boolean hasReferenceTimestamp() {
        return this.referenceTimestamp != null;
    }

    public Double getTotalWeight() {
        return this.totalWeight;
    }

    public A withTotalWeight(Double totalWeight) {
        this.totalWeight = totalWeight;
        return (A)((Object)this);
    }

    public boolean hasTotalWeight() {
        return this.totalWeight != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HistogramCheckpointFluent that = (HistogramCheckpointFluent)((Object)o);
        if (!Objects.equals(this.bucketWeights, that.bucketWeights)) {
            return false;
        }
        if (!Objects.equals(this.referenceTimestamp, that.referenceTimestamp)) {
            return false;
        }
        return Objects.equals(this.totalWeight, that.totalWeight);
    }

    public int hashCode() {
        return Objects.hash(this.bucketWeights, this.referenceTimestamp, this.totalWeight, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucketWeights != null && !this.bucketWeights.isEmpty()) {
            sb.append("bucketWeights:");
            sb.append(this.bucketWeights + ",");
        }
        if (this.referenceTimestamp != null) {
            sb.append("referenceTimestamp:");
            sb.append(this.referenceTimestamp + ",");
        }
        if (this.totalWeight != null) {
            sb.append("totalWeight:");
            sb.append(this.totalWeight);
        }
        sb.append("}");
        return sb.toString();
    }
}

