package io.fabric8.verticalpodautoscaler.api.model.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.autoscaling.v1.CrossVersionObjectReference;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VerticalPodAutoscalerSpecFluent<A extends VerticalPodAutoscalerSpecFluent<A>> extends BaseFluent<A>{
  public VerticalPodAutoscalerSpecFluent() {
  }
  public VerticalPodAutoscalerSpecFluent(VerticalPodAutoscalerSpec instance) {
    instance = (instance != null ? instance : new VerticalPodAutoscalerSpec());

    if (instance != null) {
      this.withResourcePolicy(instance.getResourcePolicy());
      this.withTargetRef(instance.getTargetRef());
      this.withUpdatePolicy(instance.getUpdatePolicy());
      this.withResourcePolicy(instance.getResourcePolicy());
      this.withTargetRef(instance.getTargetRef());
      this.withUpdatePolicy(instance.getUpdatePolicy());
    }
  }
  private PodResourcePolicyBuilder resourcePolicy;
  private CrossVersionObjectReference targetRef;
  private PodUpdatePolicyBuilder updatePolicy;
  public PodResourcePolicy buildResourcePolicy() {
    return this.resourcePolicy!=null ?this.resourcePolicy.build():null;
  }
  public A withResourcePolicy(PodResourcePolicy resourcePolicy) {
    _visitables.get("resourcePolicy").remove(this.resourcePolicy);
    if (resourcePolicy!=null){ this.resourcePolicy= new PodResourcePolicyBuilder(resourcePolicy); _visitables.get("resourcePolicy").add(this.resourcePolicy);} else { this.resourcePolicy = null; _visitables.get("resourcePolicy").remove(this.resourcePolicy); } return (A) this;
  }
  public boolean hasResourcePolicy() {
    return this.resourcePolicy != null;
  }
  public ResourcePolicyNested<A> withNewResourcePolicy() {
    return new ResourcePolicyNested(null);
  }
  public ResourcePolicyNested<A> withNewResourcePolicyLike(PodResourcePolicy item) {
    return new ResourcePolicyNested(item);
  }
  public ResourcePolicyNested<A> editResourcePolicy() {
    return withNewResourcePolicyLike(java.util.Optional.ofNullable(buildResourcePolicy()).orElse(null));
  }
  public ResourcePolicyNested<A> editOrNewResourcePolicy() {
    return withNewResourcePolicyLike(java.util.Optional.ofNullable(buildResourcePolicy()).orElse(new PodResourcePolicyBuilder().build()));
  }
  public ResourcePolicyNested<A> editOrNewResourcePolicyLike(PodResourcePolicy item) {
    return withNewResourcePolicyLike(java.util.Optional.ofNullable(buildResourcePolicy()).orElse(item));
  }
  public CrossVersionObjectReference getTargetRef() {
    return this.targetRef;
  }
  public A withTargetRef(CrossVersionObjectReference targetRef) {
    this.targetRef=targetRef; return (A) this;
  }
  public boolean hasTargetRef() {
    return this.targetRef != null;
  }
  public A withNewTargetRef(String apiVersion,String kind,String name) {
    return (A)withTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  public PodUpdatePolicy buildUpdatePolicy() {
    return this.updatePolicy!=null ?this.updatePolicy.build():null;
  }
  public A withUpdatePolicy(PodUpdatePolicy updatePolicy) {
    _visitables.get("updatePolicy").remove(this.updatePolicy);
    if (updatePolicy!=null){ this.updatePolicy= new PodUpdatePolicyBuilder(updatePolicy); _visitables.get("updatePolicy").add(this.updatePolicy);} else { this.updatePolicy = null; _visitables.get("updatePolicy").remove(this.updatePolicy); } return (A) this;
  }
  public boolean hasUpdatePolicy() {
    return this.updatePolicy != null;
  }
  public A withNewUpdatePolicy(String updateMode) {
    return (A)withUpdatePolicy(new PodUpdatePolicy(updateMode));
  }
  public UpdatePolicyNested<A> withNewUpdatePolicy() {
    return new UpdatePolicyNested(null);
  }
  public UpdatePolicyNested<A> withNewUpdatePolicyLike(PodUpdatePolicy item) {
    return new UpdatePolicyNested(item);
  }
  public UpdatePolicyNested<A> editUpdatePolicy() {
    return withNewUpdatePolicyLike(java.util.Optional.ofNullable(buildUpdatePolicy()).orElse(null));
  }
  public UpdatePolicyNested<A> editOrNewUpdatePolicy() {
    return withNewUpdatePolicyLike(java.util.Optional.ofNullable(buildUpdatePolicy()).orElse(new PodUpdatePolicyBuilder().build()));
  }
  public UpdatePolicyNested<A> editOrNewUpdatePolicyLike(PodUpdatePolicy item) {
    return withNewUpdatePolicyLike(java.util.Optional.ofNullable(buildUpdatePolicy()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VerticalPodAutoscalerSpecFluent that = (VerticalPodAutoscalerSpecFluent) o;
    if (!java.util.Objects.equals(resourcePolicy, that.resourcePolicy)) return false;

    if (!java.util.Objects.equals(targetRef, that.targetRef)) return false;

    if (!java.util.Objects.equals(updatePolicy, that.updatePolicy)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(resourcePolicy,  targetRef,  updatePolicy,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (resourcePolicy != null) { sb.append("resourcePolicy:"); sb.append(resourcePolicy + ","); }
    if (targetRef != null) { sb.append("targetRef:"); sb.append(targetRef + ","); }
    if (updatePolicy != null) { sb.append("updatePolicy:"); sb.append(updatePolicy); }
    sb.append("}");
    return sb.toString();
  }
  public class ResourcePolicyNested<N> extends PodResourcePolicyFluent<ResourcePolicyNested<N>> implements Nested<N>{
    ResourcePolicyNested(PodResourcePolicy item) {
      this.builder = new PodResourcePolicyBuilder(this, item);
    }
    PodResourcePolicyBuilder builder;
    public N and() {
      return (N) VerticalPodAutoscalerSpecFluent.this.withResourcePolicy(builder.build());
    }
    public N endResourcePolicy() {
      return and();
    }
    
  }
  public class UpdatePolicyNested<N> extends PodUpdatePolicyFluent<UpdatePolicyNested<N>> implements Nested<N>{
    UpdatePolicyNested(PodUpdatePolicy item) {
      this.builder = new PodUpdatePolicyBuilder(this, item);
    }
    PodUpdatePolicyBuilder builder;
    public N and() {
      return (N) VerticalPodAutoscalerSpecFluent.this.withUpdatePolicy(builder.build());
    }
    public N endUpdatePolicy() {
      return and();
    }
    
  }
  
}