package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodUpdatePolicyBuilder extends PodUpdatePolicyFluent<PodUpdatePolicyBuilder> implements VisitableBuilder<PodUpdatePolicy,PodUpdatePolicyBuilder>{
  public PodUpdatePolicyBuilder() {
    this(false);
  }
  public PodUpdatePolicyBuilder(Boolean validationEnabled) {
    this(new PodUpdatePolicy(), validationEnabled);
  }
  public PodUpdatePolicyBuilder(PodUpdatePolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public PodUpdatePolicyBuilder(PodUpdatePolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodUpdatePolicy(), validationEnabled);
  }
  public PodUpdatePolicyBuilder(PodUpdatePolicyFluent<?> fluent,PodUpdatePolicy instance) {
    this(fluent, instance, false);
  }
  public PodUpdatePolicyBuilder(PodUpdatePolicyFluent<?> fluent,PodUpdatePolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodUpdatePolicy());

    if (instance != null) {
      fluent.withUpdateMode(instance.getUpdateMode());
      fluent.withUpdateMode(instance.getUpdateMode());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodUpdatePolicyBuilder(PodUpdatePolicy instance) {
    this(instance,false);
  }
  public PodUpdatePolicyBuilder(PodUpdatePolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodUpdatePolicy());

    if (instance != null) {
      this.withUpdateMode(instance.getUpdateMode());
      this.withUpdateMode(instance.getUpdateMode());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodUpdatePolicyFluent<?> fluent;
  Boolean validationEnabled;
  public PodUpdatePolicy build() {
    PodUpdatePolicy buildable = new PodUpdatePolicy(fluent.getUpdateMode());
    return buildable;
  }
  
}