package io.fabric8.verticalpodautoscaler.api.model.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Double;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HistogramCheckpointFluent<A extends HistogramCheckpointFluent<A>> extends BaseFluent<A>{
  public HistogramCheckpointFluent() {
  }
  public HistogramCheckpointFluent(HistogramCheckpoint instance) {
    instance = (instance != null ? instance : new HistogramCheckpoint());

    if (instance != null) {
      this.withBucketWeights(instance.getBucketWeights());
      this.withReferenceTimestamp(instance.getReferenceTimestamp());
      this.withTotalWeight(instance.getTotalWeight());
      this.withBucketWeights(instance.getBucketWeights());
      this.withReferenceTimestamp(instance.getReferenceTimestamp());
      this.withTotalWeight(instance.getTotalWeight());
    }
  }
  private Map<Integer,Long> bucketWeights;
  private String referenceTimestamp;
  private Double totalWeight;
  public A addToBucketWeights(Integer key,Long value) {
    if(this.bucketWeights == null && key != null && value != null) { this.bucketWeights = new LinkedHashMap(); }
    if(key != null && value != null) {this.bucketWeights.put(key, value);} return (A)this;
  }
  public A addToBucketWeights(Map<Integer,Long> map) {
    if(this.bucketWeights == null && map != null) { this.bucketWeights = new LinkedHashMap(); }
    if(map != null) { this.bucketWeights.putAll(map);} return (A)this;
  }
  public A removeFromBucketWeights(Integer key) {
    if(this.bucketWeights == null) { return (A) this; }
    if(key != null && this.bucketWeights != null) {this.bucketWeights.remove(key);} return (A)this;
  }
  public A removeFromBucketWeights(Map<Integer,Long> map) {
    if(this.bucketWeights == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.bucketWeights != null){this.bucketWeights.remove(key);}}} return (A)this;
  }
  public Map<Integer,Long> getBucketWeights() {
    return this.bucketWeights;
  }
  public <K,V>A withBucketWeights(Map<Integer,Long> bucketWeights) {
    if (bucketWeights == null) { this.bucketWeights =  null;} else {this.bucketWeights = new LinkedHashMap(bucketWeights);} return (A) this;
  }
  public boolean hasBucketWeights() {
    return this.bucketWeights != null;
  }
  public String getReferenceTimestamp() {
    return this.referenceTimestamp;
  }
  public A withReferenceTimestamp(String referenceTimestamp) {
    this.referenceTimestamp=referenceTimestamp; return (A) this;
  }
  public boolean hasReferenceTimestamp() {
    return this.referenceTimestamp != null;
  }
  public Double getTotalWeight() {
    return this.totalWeight;
  }
  public A withTotalWeight(Double totalWeight) {
    this.totalWeight=totalWeight; return (A) this;
  }
  public boolean hasTotalWeight() {
    return this.totalWeight != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HistogramCheckpointFluent that = (HistogramCheckpointFluent) o;
    if (!java.util.Objects.equals(bucketWeights, that.bucketWeights)) return false;

    if (!java.util.Objects.equals(referenceTimestamp, that.referenceTimestamp)) return false;

    if (!java.util.Objects.equals(totalWeight, that.totalWeight)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bucketWeights,  referenceTimestamp,  totalWeight,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bucketWeights != null && !bucketWeights.isEmpty()) { sb.append("bucketWeights:"); sb.append(bucketWeights + ","); }
    if (referenceTimestamp != null) { sb.append("referenceTimestamp:"); sb.append(referenceTimestamp + ","); }
    if (totalWeight != null) { sb.append("totalWeight:"); sb.append(totalWeight); }
    sb.append("}");
    return sb.toString();
  }
  
}