package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerResourcePolicyBuilder extends ContainerResourcePolicyFluent<ContainerResourcePolicyBuilder> implements VisitableBuilder<ContainerResourcePolicy,ContainerResourcePolicyBuilder>{
  public ContainerResourcePolicyBuilder() {
    this(false);
  }
  public ContainerResourcePolicyBuilder(Boolean validationEnabled) {
    this(new ContainerResourcePolicy(), validationEnabled);
  }
  public ContainerResourcePolicyBuilder(ContainerResourcePolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerResourcePolicyBuilder(ContainerResourcePolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerResourcePolicy(), validationEnabled);
  }
  public ContainerResourcePolicyBuilder(ContainerResourcePolicyFluent<?> fluent,ContainerResourcePolicy instance) {
    this(fluent, instance, false);
  }
  public ContainerResourcePolicyBuilder(ContainerResourcePolicyFluent<?> fluent,ContainerResourcePolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerResourcePolicy());

    if (instance != null) {
      fluent.withContainerName(instance.getContainerName());
      fluent.withControlledResources(instance.getControlledResources());
      fluent.withControlledValues(instance.getControlledValues());
      fluent.withMaxAllowed(instance.getMaxAllowed());
      fluent.withMinAllowed(instance.getMinAllowed());
      fluent.withMode(instance.getMode());
      fluent.withContainerName(instance.getContainerName());
      fluent.withControlledResources(instance.getControlledResources());
      fluent.withControlledValues(instance.getControlledValues());
      fluent.withMaxAllowed(instance.getMaxAllowed());
      fluent.withMinAllowed(instance.getMinAllowed());
      fluent.withMode(instance.getMode());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerResourcePolicyBuilder(ContainerResourcePolicy instance) {
    this(instance,false);
  }
  public ContainerResourcePolicyBuilder(ContainerResourcePolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerResourcePolicy());

    if (instance != null) {
      this.withContainerName(instance.getContainerName());
      this.withControlledResources(instance.getControlledResources());
      this.withControlledValues(instance.getControlledValues());
      this.withMaxAllowed(instance.getMaxAllowed());
      this.withMinAllowed(instance.getMinAllowed());
      this.withMode(instance.getMode());
      this.withContainerName(instance.getContainerName());
      this.withControlledResources(instance.getControlledResources());
      this.withControlledValues(instance.getControlledValues());
      this.withMaxAllowed(instance.getMaxAllowed());
      this.withMinAllowed(instance.getMinAllowed());
      this.withMode(instance.getMode());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerResourcePolicyFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerResourcePolicy build() {
    ContainerResourcePolicy buildable = new ContainerResourcePolicy(fluent.getContainerName(),fluent.getControlledResources(),fluent.getControlledValues(),fluent.getMaxAllowed(),fluent.getMinAllowed(),fluent.getMode());
    return buildable;
  }
  
}