package io.fabric8.verticalpodautoscaler.api.model.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VerticalPodAutoscalerCheckpointStatusFluentImpl<A extends VerticalPodAutoscalerCheckpointStatusFluent<A>> extends BaseFluent<A> implements VerticalPodAutoscalerCheckpointStatusFluent<A>{
  public VerticalPodAutoscalerCheckpointStatusFluentImpl() {
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl(VerticalPodAutoscalerCheckpointStatus instance) {
    if (instance != null) {
      this.withCpuHistogram(instance.getCpuHistogram());
      this.withFirstSampleStart(instance.getFirstSampleStart());
      this.withLastSampleStart(instance.getLastSampleStart());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMemoryHistogram(instance.getMemoryHistogram());
      this.withTotalSamplesCount(instance.getTotalSamplesCount());
      this.withVersion(instance.getVersion());
    }
  }
  private HistogramCheckpointBuilder cpuHistogram;
  private String firstSampleStart;
  private String lastSampleStart;
  private String lastUpdateTime;
  private HistogramCheckpointBuilder memoryHistogram;
  private Integer totalSamplesCount;
  private String version;
  
  /**
   * This method has been deprecated, please use method buildCpuHistogram instead.
   * @return The buildable object.
   */
  @Deprecated
  public HistogramCheckpoint getCpuHistogram() {
    return this.cpuHistogram!=null ?this.cpuHistogram.build():null;
  }
  public HistogramCheckpoint buildCpuHistogram() {
    return this.cpuHistogram!=null ?this.cpuHistogram.build():null;
  }
  public A withCpuHistogram(HistogramCheckpoint cpuHistogram) {
    _visitables.get("cpuHistogram").remove(this.cpuHistogram);
    if (cpuHistogram!=null){ this.cpuHistogram= new HistogramCheckpointBuilder(cpuHistogram); _visitables.get("cpuHistogram").add(this.cpuHistogram);} else { this.cpuHistogram = null; _visitables.get("cpuHistogram").remove(this.cpuHistogram); } return (A) this;
  }
  public Boolean hasCpuHistogram() {
    return this.cpuHistogram != null;
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl.CpuHistogramNested<A> withNewCpuHistogram() {
    return new VerticalPodAutoscalerCheckpointStatusFluentImpl.CpuHistogramNestedImpl();
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl.CpuHistogramNested<A> withNewCpuHistogramLike(HistogramCheckpoint item) {
    return new VerticalPodAutoscalerCheckpointStatusFluentImpl.CpuHistogramNestedImpl(item);
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl.CpuHistogramNested<A> editCpuHistogram() {
    return withNewCpuHistogramLike(getCpuHistogram());
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl.CpuHistogramNested<A> editOrNewCpuHistogram() {
    return withNewCpuHistogramLike(getCpuHistogram() != null ? getCpuHistogram(): new HistogramCheckpointBuilder().build());
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl.CpuHistogramNested<A> editOrNewCpuHistogramLike(HistogramCheckpoint item) {
    return withNewCpuHistogramLike(getCpuHistogram() != null ? getCpuHistogram(): item);
  }
  public String getFirstSampleStart() {
    return this.firstSampleStart;
  }
  public A withFirstSampleStart(String firstSampleStart) {
    this.firstSampleStart=firstSampleStart; return (A) this;
  }
  public Boolean hasFirstSampleStart() {
    return this.firstSampleStart != null;
  }
  public String getLastSampleStart() {
    return this.lastSampleStart;
  }
  public A withLastSampleStart(String lastSampleStart) {
    this.lastSampleStart=lastSampleStart; return (A) this;
  }
  public Boolean hasLastSampleStart() {
    return this.lastSampleStart != null;
  }
  public String getLastUpdateTime() {
    return this.lastUpdateTime;
  }
  public A withLastUpdateTime(String lastUpdateTime) {
    this.lastUpdateTime=lastUpdateTime; return (A) this;
  }
  public Boolean hasLastUpdateTime() {
    return this.lastUpdateTime != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMemoryHistogram instead.
   * @return The buildable object.
   */
  @Deprecated
  public HistogramCheckpoint getMemoryHistogram() {
    return this.memoryHistogram!=null ?this.memoryHistogram.build():null;
  }
  public HistogramCheckpoint buildMemoryHistogram() {
    return this.memoryHistogram!=null ?this.memoryHistogram.build():null;
  }
  public A withMemoryHistogram(HistogramCheckpoint memoryHistogram) {
    _visitables.get("memoryHistogram").remove(this.memoryHistogram);
    if (memoryHistogram!=null){ this.memoryHistogram= new HistogramCheckpointBuilder(memoryHistogram); _visitables.get("memoryHistogram").add(this.memoryHistogram);} else { this.memoryHistogram = null; _visitables.get("memoryHistogram").remove(this.memoryHistogram); } return (A) this;
  }
  public Boolean hasMemoryHistogram() {
    return this.memoryHistogram != null;
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl.MemoryHistogramNested<A> withNewMemoryHistogram() {
    return new VerticalPodAutoscalerCheckpointStatusFluentImpl.MemoryHistogramNestedImpl();
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl.MemoryHistogramNested<A> withNewMemoryHistogramLike(HistogramCheckpoint item) {
    return new VerticalPodAutoscalerCheckpointStatusFluentImpl.MemoryHistogramNestedImpl(item);
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl.MemoryHistogramNested<A> editMemoryHistogram() {
    return withNewMemoryHistogramLike(getMemoryHistogram());
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl.MemoryHistogramNested<A> editOrNewMemoryHistogram() {
    return withNewMemoryHistogramLike(getMemoryHistogram() != null ? getMemoryHistogram(): new HistogramCheckpointBuilder().build());
  }
  public VerticalPodAutoscalerCheckpointStatusFluentImpl.MemoryHistogramNested<A> editOrNewMemoryHistogramLike(HistogramCheckpoint item) {
    return withNewMemoryHistogramLike(getMemoryHistogram() != null ? getMemoryHistogram(): item);
  }
  public Integer getTotalSamplesCount() {
    return this.totalSamplesCount;
  }
  public A withTotalSamplesCount(Integer totalSamplesCount) {
    this.totalSamplesCount=totalSamplesCount; return (A) this;
  }
  public Boolean hasTotalSamplesCount() {
    return this.totalSamplesCount != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VerticalPodAutoscalerCheckpointStatusFluentImpl that = (VerticalPodAutoscalerCheckpointStatusFluentImpl) o;
    if (!java.util.Objects.equals(cpuHistogram, that.cpuHistogram)) return false;

    if (!java.util.Objects.equals(firstSampleStart, that.firstSampleStart)) return false;

    if (!java.util.Objects.equals(lastSampleStart, that.lastSampleStart)) return false;

    if (!java.util.Objects.equals(lastUpdateTime, that.lastUpdateTime)) return false;

    if (!java.util.Objects.equals(memoryHistogram, that.memoryHistogram)) return false;

    if (!java.util.Objects.equals(totalSamplesCount, that.totalSamplesCount)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cpuHistogram,  firstSampleStart,  lastSampleStart,  lastUpdateTime,  memoryHistogram,  totalSamplesCount,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cpuHistogram != null) { sb.append("cpuHistogram:"); sb.append(cpuHistogram + ","); }
    if (firstSampleStart != null) { sb.append("firstSampleStart:"); sb.append(firstSampleStart + ","); }
    if (lastSampleStart != null) { sb.append("lastSampleStart:"); sb.append(lastSampleStart + ","); }
    if (lastUpdateTime != null) { sb.append("lastUpdateTime:"); sb.append(lastUpdateTime + ","); }
    if (memoryHistogram != null) { sb.append("memoryHistogram:"); sb.append(memoryHistogram + ","); }
    if (totalSamplesCount != null) { sb.append("totalSamplesCount:"); sb.append(totalSamplesCount + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class CpuHistogramNestedImpl<N> extends HistogramCheckpointFluentImpl<VerticalPodAutoscalerCheckpointStatusFluentImpl.CpuHistogramNested<N>> implements VerticalPodAutoscalerCheckpointStatusFluentImpl.CpuHistogramNested<N>,Nested<N>{
    CpuHistogramNestedImpl(HistogramCheckpoint item) {
      this.builder = new HistogramCheckpointBuilder(this, item);
    }
    CpuHistogramNestedImpl() {
      this.builder = new HistogramCheckpointBuilder(this);
    }
    HistogramCheckpointBuilder builder;
    public N and() {
      return (N) VerticalPodAutoscalerCheckpointStatusFluentImpl.this.withCpuHistogram(builder.build());
    }
    public N endCpuHistogram() {
      return and();
    }
    
  }
  class MemoryHistogramNestedImpl<N> extends HistogramCheckpointFluentImpl<VerticalPodAutoscalerCheckpointStatusFluentImpl.MemoryHistogramNested<N>> implements VerticalPodAutoscalerCheckpointStatusFluentImpl.MemoryHistogramNested<N>,Nested<N>{
    MemoryHistogramNestedImpl(HistogramCheckpoint item) {
      this.builder = new HistogramCheckpointBuilder(this, item);
    }
    MemoryHistogramNestedImpl() {
      this.builder = new HistogramCheckpointBuilder(this);
    }
    HistogramCheckpointBuilder builder;
    public N and() {
      return (N) VerticalPodAutoscalerCheckpointStatusFluentImpl.this.withMemoryHistogram(builder.build());
    }
    public N endMemoryHistogram() {
      return and();
    }
    
  }
  
}