package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VerticalPodAutoscalerCheckpointStatusBuilder extends VerticalPodAutoscalerCheckpointStatusFluentImpl<VerticalPodAutoscalerCheckpointStatusBuilder> implements VisitableBuilder<VerticalPodAutoscalerCheckpointStatus,VerticalPodAutoscalerCheckpointStatusBuilder>{
  public VerticalPodAutoscalerCheckpointStatusBuilder() {
    this(false);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(Boolean validationEnabled) {
    this(new VerticalPodAutoscalerCheckpointStatus(), validationEnabled);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(VerticalPodAutoscalerCheckpointStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(VerticalPodAutoscalerCheckpointStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VerticalPodAutoscalerCheckpointStatus(), validationEnabled);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(VerticalPodAutoscalerCheckpointStatusFluent<?> fluent,VerticalPodAutoscalerCheckpointStatus instance) {
    this(fluent, instance, false);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(VerticalPodAutoscalerCheckpointStatusFluent<?> fluent,VerticalPodAutoscalerCheckpointStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCpuHistogram(instance.getCpuHistogram());
      fluent.withFirstSampleStart(instance.getFirstSampleStart());
      fluent.withLastSampleStart(instance.getLastSampleStart());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMemoryHistogram(instance.getMemoryHistogram());
      fluent.withTotalSamplesCount(instance.getTotalSamplesCount());
      fluent.withVersion(instance.getVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(VerticalPodAutoscalerCheckpointStatus instance) {
    this(instance,false);
  }
  public VerticalPodAutoscalerCheckpointStatusBuilder(VerticalPodAutoscalerCheckpointStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCpuHistogram(instance.getCpuHistogram());
      this.withFirstSampleStart(instance.getFirstSampleStart());
      this.withLastSampleStart(instance.getLastSampleStart());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMemoryHistogram(instance.getMemoryHistogram());
      this.withTotalSamplesCount(instance.getTotalSamplesCount());
      this.withVersion(instance.getVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  VerticalPodAutoscalerCheckpointStatusFluent<?> fluent;
  Boolean validationEnabled;
  public VerticalPodAutoscalerCheckpointStatus build() {
    VerticalPodAutoscalerCheckpointStatus buildable = new VerticalPodAutoscalerCheckpointStatus(fluent.getCpuHistogram(),fluent.getFirstSampleStart(),fluent.getLastSampleStart(),fluent.getLastUpdateTime(),fluent.getMemoryHistogram(),fluent.getTotalSamplesCount(),fluent.getVersion());
    return buildable;
  }
  
}