package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VerticalPodAutoscalerCheckpointBuilder extends VerticalPodAutoscalerCheckpointFluentImpl<VerticalPodAutoscalerCheckpointBuilder> implements VisitableBuilder<VerticalPodAutoscalerCheckpoint,VerticalPodAutoscalerCheckpointBuilder>{
  public VerticalPodAutoscalerCheckpointBuilder() {
    this(false);
  }
  public VerticalPodAutoscalerCheckpointBuilder(Boolean validationEnabled) {
    this(new VerticalPodAutoscalerCheckpoint(), validationEnabled);
  }
  public VerticalPodAutoscalerCheckpointBuilder(VerticalPodAutoscalerCheckpointFluent<?> fluent) {
    this(fluent, false);
  }
  public VerticalPodAutoscalerCheckpointBuilder(VerticalPodAutoscalerCheckpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VerticalPodAutoscalerCheckpoint(), validationEnabled);
  }
  public VerticalPodAutoscalerCheckpointBuilder(VerticalPodAutoscalerCheckpointFluent<?> fluent,VerticalPodAutoscalerCheckpoint instance) {
    this(fluent, instance, false);
  }
  public VerticalPodAutoscalerCheckpointBuilder(VerticalPodAutoscalerCheckpointFluent<?> fluent,VerticalPodAutoscalerCheckpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VerticalPodAutoscalerCheckpointBuilder(VerticalPodAutoscalerCheckpoint instance) {
    this(instance,false);
  }
  public VerticalPodAutoscalerCheckpointBuilder(VerticalPodAutoscalerCheckpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  VerticalPodAutoscalerCheckpointFluent<?> fluent;
  Boolean validationEnabled;
  public VerticalPodAutoscalerCheckpoint build() {
    VerticalPodAutoscalerCheckpoint buildable = new VerticalPodAutoscalerCheckpoint(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}