package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RecommendedPodResourcesBuilder extends RecommendedPodResourcesFluentImpl<RecommendedPodResourcesBuilder> implements VisitableBuilder<RecommendedPodResources,RecommendedPodResourcesBuilder>{
  public RecommendedPodResourcesBuilder() {
    this(false);
  }
  public RecommendedPodResourcesBuilder(Boolean validationEnabled) {
    this(new RecommendedPodResources(), validationEnabled);
  }
  public RecommendedPodResourcesBuilder(RecommendedPodResourcesFluent<?> fluent) {
    this(fluent, false);
  }
  public RecommendedPodResourcesBuilder(RecommendedPodResourcesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RecommendedPodResources(), validationEnabled);
  }
  public RecommendedPodResourcesBuilder(RecommendedPodResourcesFluent<?> fluent,RecommendedPodResources instance) {
    this(fluent, instance, false);
  }
  public RecommendedPodResourcesBuilder(RecommendedPodResourcesFluent<?> fluent,RecommendedPodResources instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withContainerRecommendations(instance.getContainerRecommendations());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RecommendedPodResourcesBuilder(RecommendedPodResources instance) {
    this(instance,false);
  }
  public RecommendedPodResourcesBuilder(RecommendedPodResources instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withContainerRecommendations(instance.getContainerRecommendations());
    }
    this.validationEnabled = validationEnabled; 
  }
  RecommendedPodResourcesFluent<?> fluent;
  Boolean validationEnabled;
  public RecommendedPodResources build() {
    RecommendedPodResources buildable = new RecommendedPodResources(fluent.getContainerRecommendations());
    return buildable;
  }
  
}