/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.verticalpodautoscaler.api.model.v1.RecommendedContainerResources;
import io.fabric8.verticalpodautoscaler.api.model.v1.RecommendedContainerResourcesFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class RecommendedContainerResourcesFluentImpl<A extends RecommendedContainerResourcesFluent<A>>
extends BaseFluent<A>
implements RecommendedContainerResourcesFluent<A> {
    private String containerName;
    private Map<String, Quantity> lowerBound;
    private Map<String, Quantity> target;
    private Map<String, Quantity> uncappedTarget;
    private Map<String, Quantity> upperBound;

    public RecommendedContainerResourcesFluentImpl() {
    }

    public RecommendedContainerResourcesFluentImpl(RecommendedContainerResources instance) {
        this.withContainerName(instance.getContainerName());
        this.withLowerBound(instance.getLowerBound());
        this.withTarget(instance.getTarget());
        this.withUncappedTarget(instance.getUncappedTarget());
        this.withUpperBound(instance.getUpperBound());
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public A withContainerName(String containerName) {
        this.containerName = containerName;
        return (A)this;
    }

    @Override
    public Boolean hasContainerName() {
        return this.containerName != null;
    }

    @Override
    public A addToLowerBound(String key, Quantity value) {
        if (this.lowerBound == null && key != null && value != null) {
            this.lowerBound = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.lowerBound.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLowerBound(Map<String, Quantity> map) {
        if (this.lowerBound == null && map != null) {
            this.lowerBound = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.lowerBound.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLowerBound(String key) {
        if (this.lowerBound == null) {
            return (A)this;
        }
        if (key != null && this.lowerBound != null) {
            this.lowerBound.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLowerBound(Map<String, Quantity> map) {
        if (this.lowerBound == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.lowerBound == null) continue;
                this.lowerBound.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public <K, V> A withLowerBound(Map<String, Quantity> lowerBound) {
        this.lowerBound = lowerBound == null ? null : new LinkedHashMap<String, Quantity>(lowerBound);
        return (A)this;
    }

    @Override
    public Boolean hasLowerBound() {
        return this.lowerBound != null;
    }

    @Override
    public A addToTarget(String key, Quantity value) {
        if (this.target == null && key != null && value != null) {
            this.target = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.target.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToTarget(Map<String, Quantity> map) {
        if (this.target == null && map != null) {
            this.target = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.target.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromTarget(String key) {
        if (this.target == null) {
            return (A)this;
        }
        if (key != null && this.target != null) {
            this.target.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromTarget(Map<String, Quantity> map) {
        if (this.target == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.target == null) continue;
                this.target.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getTarget() {
        return this.target;
    }

    @Override
    public <K, V> A withTarget(Map<String, Quantity> target) {
        this.target = target == null ? null : new LinkedHashMap<String, Quantity>(target);
        return (A)this;
    }

    @Override
    public Boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public A addToUncappedTarget(String key, Quantity value) {
        if (this.uncappedTarget == null && key != null && value != null) {
            this.uncappedTarget = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.uncappedTarget.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToUncappedTarget(Map<String, Quantity> map) {
        if (this.uncappedTarget == null && map != null) {
            this.uncappedTarget = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.uncappedTarget.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromUncappedTarget(String key) {
        if (this.uncappedTarget == null) {
            return (A)this;
        }
        if (key != null && this.uncappedTarget != null) {
            this.uncappedTarget.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromUncappedTarget(Map<String, Quantity> map) {
        if (this.uncappedTarget == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.uncappedTarget == null) continue;
                this.uncappedTarget.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getUncappedTarget() {
        return this.uncappedTarget;
    }

    @Override
    public <K, V> A withUncappedTarget(Map<String, Quantity> uncappedTarget) {
        this.uncappedTarget = uncappedTarget == null ? null : new LinkedHashMap<String, Quantity>(uncappedTarget);
        return (A)this;
    }

    @Override
    public Boolean hasUncappedTarget() {
        return this.uncappedTarget != null;
    }

    @Override
    public A addToUpperBound(String key, Quantity value) {
        if (this.upperBound == null && key != null && value != null) {
            this.upperBound = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.upperBound.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToUpperBound(Map<String, Quantity> map) {
        if (this.upperBound == null && map != null) {
            this.upperBound = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.upperBound.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromUpperBound(String key) {
        if (this.upperBound == null) {
            return (A)this;
        }
        if (key != null && this.upperBound != null) {
            this.upperBound.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromUpperBound(Map<String, Quantity> map) {
        if (this.upperBound == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.upperBound == null) continue;
                this.upperBound.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getUpperBound() {
        return this.upperBound;
    }

    @Override
    public <K, V> A withUpperBound(Map<String, Quantity> upperBound) {
        this.upperBound = upperBound == null ? null : new LinkedHashMap<String, Quantity>(upperBound);
        return (A)this;
    }

    @Override
    public Boolean hasUpperBound() {
        return this.upperBound != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecommendedContainerResourcesFluentImpl that = (RecommendedContainerResourcesFluentImpl)o;
        if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) {
            return false;
        }
        if (this.lowerBound != null ? !this.lowerBound.equals(that.lowerBound) : that.lowerBound != null) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        if (this.uncappedTarget != null ? !this.uncappedTarget.equals(that.uncappedTarget) : that.uncappedTarget != null) {
            return false;
        }
        return !(this.upperBound != null ? !this.upperBound.equals(that.upperBound) : that.upperBound != null);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.lowerBound, this.target, this.uncappedTarget, this.upperBound, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerName != null) {
            sb.append("containerName:");
            sb.append(this.containerName + ",");
        }
        if (this.lowerBound != null && !this.lowerBound.isEmpty()) {
            sb.append("lowerBound:");
            sb.append(this.lowerBound + ",");
        }
        if (this.target != null && !this.target.isEmpty()) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.uncappedTarget != null && !this.uncappedTarget.isEmpty()) {
            sb.append("uncappedTarget:");
            sb.append(this.uncappedTarget + ",");
        }
        if (this.upperBound != null && !this.upperBound.isEmpty()) {
            sb.append("upperBound:");
            sb.append(this.upperBound);
        }
        sb.append("}");
        return sb.toString();
    }
}

