package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VerticalPodAutoscalerStatusFluentImpl<A extends VerticalPodAutoscalerStatusFluent<A>> extends BaseFluent<A> implements VerticalPodAutoscalerStatusFluent<A>{
  public VerticalPodAutoscalerStatusFluentImpl() {
  }
  public VerticalPodAutoscalerStatusFluentImpl(VerticalPodAutoscalerStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withRecommendation(instance.getRecommendation()); 
  }
  private ArrayList<VerticalPodAutoscalerConditionBuilder> conditions = new ArrayList<VerticalPodAutoscalerConditionBuilder>();
  private RecommendedPodResourcesBuilder recommendation;
  public A addToConditions(Integer index,VerticalPodAutoscalerCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<VerticalPodAutoscalerConditionBuilder>();}
    VerticalPodAutoscalerConditionBuilder builder = new VerticalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,VerticalPodAutoscalerCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<VerticalPodAutoscalerConditionBuilder>();}
    VerticalPodAutoscalerConditionBuilder builder = new VerticalPodAutoscalerConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<VerticalPodAutoscalerConditionBuilder>();}
    for (VerticalPodAutoscalerCondition item : items) {VerticalPodAutoscalerConditionBuilder builder = new VerticalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<VerticalPodAutoscalerCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<VerticalPodAutoscalerConditionBuilder>();}
    for (VerticalPodAutoscalerCondition item : items) {VerticalPodAutoscalerConditionBuilder builder = new VerticalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCondition... items) {
    for (VerticalPodAutoscalerCondition item : items) {VerticalPodAutoscalerConditionBuilder builder = new VerticalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<VerticalPodAutoscalerCondition> items) {
    for (VerticalPodAutoscalerCondition item : items) {VerticalPodAutoscalerConditionBuilder builder = new VerticalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<VerticalPodAutoscalerConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<VerticalPodAutoscalerConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      VerticalPodAutoscalerConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<VerticalPodAutoscalerCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<VerticalPodAutoscalerCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public VerticalPodAutoscalerCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public VerticalPodAutoscalerCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public VerticalPodAutoscalerCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public VerticalPodAutoscalerCondition buildMatchingCondition(Predicate<VerticalPodAutoscalerConditionBuilder> predicate) {
    for (VerticalPodAutoscalerConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<VerticalPodAutoscalerConditionBuilder> predicate) {
    for (VerticalPodAutoscalerConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<VerticalPodAutoscalerCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (VerticalPodAutoscalerCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.verticalpodautoscaler.api.model.v1.VerticalPodAutoscalerCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (VerticalPodAutoscalerCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new VerticalPodAutoscalerCondition(lastTransitionTime, message, reason, status, type));
  }
  public VerticalPodAutoscalerStatusFluent.ConditionsNested<A> addNewCondition() {
    return new VerticalPodAutoscalerStatusFluentImpl.ConditionsNestedImpl();
  }
  public VerticalPodAutoscalerStatusFluent.ConditionsNested<A> addNewConditionLike(VerticalPodAutoscalerCondition item) {
    return new VerticalPodAutoscalerStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public VerticalPodAutoscalerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,VerticalPodAutoscalerCondition item) {
    return new VerticalPodAutoscalerStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public VerticalPodAutoscalerStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public VerticalPodAutoscalerStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public VerticalPodAutoscalerStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public VerticalPodAutoscalerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<VerticalPodAutoscalerConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildRecommendation instead.
   * @return The buildable object.
   */
  @Deprecated
  public RecommendedPodResources getRecommendation() {
    return this.recommendation!=null ?this.recommendation.build():null;
  }
  public RecommendedPodResources buildRecommendation() {
    return this.recommendation!=null ?this.recommendation.build():null;
  }
  public A withRecommendation(RecommendedPodResources recommendation) {
    _visitables.get("recommendation").remove(this.recommendation);
    if (recommendation!=null){ this.recommendation= new RecommendedPodResourcesBuilder(recommendation); _visitables.get("recommendation").add(this.recommendation);} else { this.recommendation = null; _visitables.get("recommendation").remove(this.recommendation); } return (A) this;
  }
  public Boolean hasRecommendation() {
    return this.recommendation != null;
  }
  public VerticalPodAutoscalerStatusFluent.RecommendationNested<A> withNewRecommendation() {
    return new VerticalPodAutoscalerStatusFluentImpl.RecommendationNestedImpl();
  }
  public VerticalPodAutoscalerStatusFluent.RecommendationNested<A> withNewRecommendationLike(RecommendedPodResources item) {
    return new VerticalPodAutoscalerStatusFluentImpl.RecommendationNestedImpl(item);
  }
  public VerticalPodAutoscalerStatusFluent.RecommendationNested<A> editRecommendation() {
    return withNewRecommendationLike(getRecommendation());
  }
  public VerticalPodAutoscalerStatusFluent.RecommendationNested<A> editOrNewRecommendation() {
    return withNewRecommendationLike(getRecommendation() != null ? getRecommendation(): new RecommendedPodResourcesBuilder().build());
  }
  public VerticalPodAutoscalerStatusFluent.RecommendationNested<A> editOrNewRecommendationLike(RecommendedPodResources item) {
    return withNewRecommendationLike(getRecommendation() != null ? getRecommendation(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VerticalPodAutoscalerStatusFluentImpl that = (VerticalPodAutoscalerStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (recommendation != null ? !recommendation.equals(that.recommendation) :that.recommendation != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  recommendation,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (recommendation != null) { sb.append("recommendation:"); sb.append(recommendation); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends VerticalPodAutoscalerConditionFluentImpl<VerticalPodAutoscalerStatusFluent.ConditionsNested<N>> implements VerticalPodAutoscalerStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,VerticalPodAutoscalerCondition item) {
      this.index = index;
      this.builder = new VerticalPodAutoscalerConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new VerticalPodAutoscalerConditionBuilder(this);
    }
    VerticalPodAutoscalerConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) VerticalPodAutoscalerStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class RecommendationNestedImpl<N> extends RecommendedPodResourcesFluentImpl<VerticalPodAutoscalerStatusFluent.RecommendationNested<N>> implements VerticalPodAutoscalerStatusFluent.RecommendationNested<N>,Nested<N>{
    RecommendationNestedImpl(RecommendedPodResources item) {
      this.builder = new RecommendedPodResourcesBuilder(this, item);
    }
    RecommendationNestedImpl() {
      this.builder = new RecommendedPodResourcesBuilder(this);
    }
    RecommendedPodResourcesBuilder builder;
    public N and() {
      return (N) VerticalPodAutoscalerStatusFluentImpl.this.withRecommendation(builder.build());
    }
    public N endRecommendation() {
      return and();
    }
    
  }
  
}