package io.fabric8.verticalpodautoscaler.api.model.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HistogramCheckpointBuilder extends HistogramCheckpointFluentImpl<HistogramCheckpointBuilder> implements VisitableBuilder<HistogramCheckpoint,HistogramCheckpointBuilder>{
  public HistogramCheckpointBuilder() {
    this(false);
  }
  public HistogramCheckpointBuilder(Boolean validationEnabled) {
    this(new HistogramCheckpoint(), validationEnabled);
  }
  public HistogramCheckpointBuilder(HistogramCheckpointFluent<?> fluent) {
    this(fluent, false);
  }
  public HistogramCheckpointBuilder(HistogramCheckpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HistogramCheckpoint(), validationEnabled);
  }
  public HistogramCheckpointBuilder(HistogramCheckpointFluent<?> fluent,HistogramCheckpoint instance) {
    this(fluent, instance, false);
  }
  public HistogramCheckpointBuilder(HistogramCheckpointFluent<?> fluent,HistogramCheckpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBucketWeights(instance.getBucketWeights()); 
    fluent.withReferenceTimestamp(instance.getReferenceTimestamp()); 
    fluent.withTotalWeight(instance.getTotalWeight()); 
    this.validationEnabled = validationEnabled; 
  }
  public HistogramCheckpointBuilder(HistogramCheckpoint instance) {
    this(instance,false);
  }
  public HistogramCheckpointBuilder(HistogramCheckpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBucketWeights(instance.getBucketWeights()); 
    this.withReferenceTimestamp(instance.getReferenceTimestamp()); 
    this.withTotalWeight(instance.getTotalWeight()); 
    this.validationEnabled = validationEnabled; 
  }
  HistogramCheckpointFluent<?> fluent;
  Boolean validationEnabled;
  public HistogramCheckpoint build() {
    HistogramCheckpoint buildable = new HistogramCheckpoint(fluent.getBucketWeights(),fluent.getReferenceTimestamp(),fluent.getTotalWeight());
    return buildable;
  }
  
}